% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.mode.R
\name{batch.mode}
\alias{batch.mode}
\title{Automatic rows and position detection}
\usage{
batch.mode(location, files = FALSE,
           interact = TRUE, make.plot = TRUE,
           aligning = TRUE, frac.small=0.5, swe=0.5, sle=3,
           ec=3, swl=0.5, sll=5, lc=10, prof.co=6, max.cells=0.5,
           list = FALSE, flip = FALSE)
}
\arguments{
\item{location}{a character string containing the location of input files and where the outputs (.pdf and .txt files) should be stored.}

\item{files}{a vector of files for the analyses (defaults to all files present in the folder). Text files should agree with all criteria presented in \code{\link{is.raptor}}.}

\item{interact}{a logical flag. If \code{\link{TRUE}}, the user will have the options to manually assign the degree of rotation for each annual ring. See \code{\link{align}} for rotation options. If \code{\link{FALSE}}, the rotation is optimized automatically using a simple linear regression through all points along the horizontal axis (default = \code{\link{FALSE}}).}

\item{make.plot}{logical flag indicating whether to make a plot (default =  \code{\link{FALSE}}).}

\item{aligning}{logical flag indicating whether a second alignment has to be performed based upon the cells detected within \code{\link{first.cell}} (default = \code{\link{TRUE}}).}

\item{frac.small}{a numeric value (between 0 and 1) that is multiplied by the average cell lumen size of the ring, determining the minimal threshold used to filter out too small first row tracheids (default = 0.5).}

\item{swe}{a numeric value that is multiplied by the square-rooted cell lumen area (l) of the target cell and used to determine the width of the rectangular search area which locates the next earlywood cell in the row (default = 0.5).}

\item{sle}{a numeric value that is multiplied by the square rooted cell lumen area (l) of the target cell to determine the length of the rectangle search area which locates the next earlywood cell in the row (default = 3).}

\item{ec}{threshold ratio between the lumen area of two consecutive earlywood cells to determine the end of the earlywood search (default = 1.75). The default setting indicates that the earlywood search ends when the next cell lumen area is at least 1.75 times smaller than the target cell.}

\item{swl}{a numeric value that is multiplied by the square rooted cell lumen area (l) of the target cell to determine the width of the rectangle search area which locates the next latewood cell in the row (default = 0.25).}

\item{sll}{a numeric value that is multiplied by the square rooted cell lumen area (l) of the target cell to determine the length of the rectangle search area which locates the next earlywood cell in the row (default = 5).}

\item{lc}{threshold ratio between the lumen area of two consecutive latewood cells to determine the end of the radial file (default = 10). The default setting indicates that the latewood search ends when the next cell lumen area is at least 10 times smaller than the target cell.}

\item{prof.co}{threshold ratio between the distance to the previous and consecutive cell to determine if the row (or radial file) should be excluded (default = 6).}

\item{max.cells}{threshold proportion of the maximum number of cells to determine if the radial file has to be excluded (default = 0.6).}

\item{list}{a \code{\link{data.frame}} with the individual "ID" and in sequence the slopes as described in \code{\link{pos.det}}. Cannot be activated when interact = \code{\link{TRUE}}.}

\item{flip}{logical flag indicating whether to plot the data with earlywood downwards (default; flip = \code{\link{FALSE}}) or upwards (flip = \code{\link{TRUE}}).}

\item{...}{see \code{\link{pos.det}} for arguments.}
}
\value{
Plots the detected radial files and writes output according the the
\code{\link{write.output}} format.
}
\description{
Batch.mode applies all functionalities described in \code{\link{is.raptor}}, \code{\link{align}}, \code{\link{first.cell}}, \code{\link{pos.det}} and \code{\link{write.output}}. Multiple input datasets (sample specific) can be provided in a folder and automatically used within this function. Input data should be checked for all requirements described in \code{\link{is.raptor}} and preferably adjusted with \code{\link{align}}.
}
\details{
This function aids in applying all described functions on a large dataset composed of multiple files, including multiple individuals and years. It will generate output graphs as described in \code{\link{is.raptor}}, \code{\link{align}}, \code{\link{first.cell}}, \code{\link{pos.det}} and \code{\link{write.output}} in a .pdf file. Additionally, output text files are written. All output files are exported into the directory specified in the location argument.
}
