% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal.R
\name{SCM}
\alias{SCM}
\title{R6 Class for structural causal models}
\description{
R6 Class for structural causal models

R6 Class for structural causal models
}
\details{
An R6 class for structural causal models (SCM)
with latent variables and missing data mechanism. There are methods for
defining, printing, plotting, intervening and simulating SCMs.
}
\examples{

## ------------------------------------------------
## Method `SCM$new`
## ------------------------------------------------

backdoor <- SCM$new("backdoor",
 uflist = list(
  uz = function(n) {return(stats::runif(n))},
  ux = function(n) {return(stats::runif(n))},
  uy = function(n) {return(stats::runif(n))}
 ),
 vflist = list(
  z = function(uz) {
    return(as.numeric(uz < 0.4))},
  x = function(ux, z) {
    return(as.numeric(ux < 0.2 + 0.5*z))},
  y = function(uy, z, x) {
    return(as.numeric(uy < 0.1 + 0.4*z + 0.4*x))}
 )
)

## ------------------------------------------------
## Method `SCM$print`
## ------------------------------------------------

backdoor

## ------------------------------------------------
## Method `SCM$plot`
## ------------------------------------------------

backdoor$plot()
backdoor$plot("v")

## ------------------------------------------------
## Method `SCM$add_variable`
## ------------------------------------------------

backdoor2 <- backdoor$clone()
backdoor2$add_variable(
   vfnew = list(
             w = function(uw, x) {
             return(as.numeric(uw < 0.4 + 0.3*x))}),
   ufnew = list(
            uw = function(n) {return(stats::runif(n))})
) 

## ------------------------------------------------
## Method `SCM$remove_variable`
## ------------------------------------------------

backdoor2 <- backdoor$clone()
backdoor2$remove_variable(c("uy","y"))
#' @include R6causal.R R6causal_examples.R
NULL

## ------------------------------------------------
## Method `SCM$dosearch`
## ------------------------------------------------

backdoor$dosearch(data = "p(x,y,z)", query = "p(y|do(x))")

## ------------------------------------------------
## Method `SCM$intervene`
## ------------------------------------------------

# A simple intervention
backdoor_x1 <- backdoor$clone()  # making a copy
backdoor_x1$intervene("x",1) # applying the intervention
backdoor_x1$plot() # to see that arrows incoming to x are cut

# An intervention that redefines a structural equation
backdoor_yz <- backdoor$clone()  # making a copy
backdoor_yz$intervene("y",
    function(uy, z) {return(as.numeric(uy < 0.1 + 0.8*z ))}) # making y a function of z only
backdoor_yz$plot() # to see that arrow x -> y is cut

## ------------------------------------------------
## Method `SCM$simulate`
## ------------------------------------------------

backdoor$simulate(8, return_simdata = TRUE, store_simdata = FALSE)
backdoor$simulate(10)
backdoor$simdata
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{vflist}}{List of the structural functions of observed variables.}

\item{\code{vnames}}{List of the names of observed variables.}

\item{\code{vfsymb}}{List of the arguments of structural functions of observed variables.}

\item{\code{uflist}}{List of the structural functions of unobserved variables.}

\item{\code{unames}}{List of the names of unobserved variables.}

\item{\code{unames_dedicated}}{List of the names of unobserved variables that have only one child.}

\item{\code{unames_confounder}}{List of the names of unobserved variables that 
have two or more children.}

\item{\code{dedicated_u}}{Named list of the names of unobserved variables that 
have only one child which is the name of the element.}

\item{\code{is_linear_gaussian}}{Logical, does the SCM have linear functions 
and Gaussian background variables?}

\item{\code{rflist}}{List of the structural functions of missingness indicators.}

\item{\code{rfsymb}}{List of the names of missingness indicators.}

\item{\code{rprefix}}{Prefix used to mark missingness indicators.}

\item{\code{starsuffix}}{Suffix used to mark variables with missing data.}

\item{\code{simdata}}{Data table containing data simulated from the SCM.}

\item{\code{simdata_md}}{Data table containing data simulated from the SCM
where missing values are indicated by \code{NA}.}

\item{\code{igraph}}{The graph of the SCM in the \code{igraph} form
(without the missing data mechanism).}

\item{\code{igraph_nodedicated}}{The graph of the SCM in the \code{igraph} form
(without the dedicated U variables and the missing data mechanism).}

\item{\code{igraph_bidirected}}{The graph of the SCM in the \code{igraph} form where
latent variables are presented by bidirected arcs.}

\item{\code{igraph_md}}{The graph of the SCM in the \code{igraph} form including
the missing data mechanism.}

\item{\code{toporder}}{A vector giving the topological order of variables.}

\item{\code{toporderv}}{A vector giving the topological order of observed
variables.}

\item{\code{graphtext}}{A character string that gives the edges of the graph
of the SCM (without the missing data mechanism).}

\item{\code{graphtext_md}}{A character string that gives the edges of the graph
of the SCM including the missing data mechanism.}

\item{\code{name}}{The name of the SCM.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SCM-new}{\code{SCM$new()}}
\item \href{#method-SCM-print}{\code{SCM$print()}}
\item \href{#method-SCM-plot}{\code{SCM$plot()}}
\item \href{#method-SCM-tikz}{\code{SCM$tikz()}}
\item \href{#method-SCM-pa}{\code{SCM$pa()}}
\item \href{#method-SCM-ch}{\code{SCM$ch()}}
\item \href{#method-SCM-an}{\code{SCM$an()}}
\item \href{#method-SCM-de}{\code{SCM$de()}}
\item \href{#method-SCM-add_variable}{\code{SCM$add_variable()}}
\item \href{#method-SCM-remove_variable}{\code{SCM$remove_variable()}}
\item \href{#method-SCM-causal.effect}{\code{SCM$causal.effect()}}
\item \href{#method-SCM-dosearch}{\code{SCM$dosearch()}}
\item \href{#method-SCM-intervene}{\code{SCM$intervene()}}
\item \href{#method-SCM-simulate}{\code{SCM$simulate()}}
\item \href{#method-SCM-clone}{\code{SCM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-new"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-new}{}}}
\subsection{Method \code{new()}}{
Create a new SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$new(
  name = "An SCM",
  uflist = NULL,
  vflist = NULL,
  rflist = NULL,
  rprefix = "R_",
  starsuffix = "_md"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name.}

\item{\code{uflist}}{A named list containing the functions for the background variables.}

\item{\code{vflist}}{A named list containing the functions for the observed variables.}

\item{\code{rflist}}{A named list containing the functions for missingness indicators.}

\item{\code{rprefix}}{The prefix of the missingness indicators.}

\item{\code{starsuffix}}{The suffix for variables with missing data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `SCM` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor <- SCM$new("backdoor",
 uflist = list(
  uz = function(n) {return(stats::runif(n))},
  ux = function(n) {return(stats::runif(n))},
  uy = function(n) {return(stats::runif(n))}
 ),
 vflist = list(
  z = function(uz) {
    return(as.numeric(uz < 0.4))},
  x = function(ux, z) {
    return(as.numeric(ux < 0.2 + 0.5*z))},
  y = function(uy, z, x) {
    return(as.numeric(uy < 0.1 + 0.4*z + 0.4*x))}
 )
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-print"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-print}{}}}
\subsection{Method \code{print()}}{
Print a summmary of the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-plot"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the DAG of the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$plot(subset = "uvr", method = "igraph", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subset}}{Variable groups to be plotted: "uvr", "u2vr","vr","uv", "u2v" or "v".}

\item{\code{method}}{Plotting method: "qgraph" or "igraph".}

\item{\code{...}}{other parameters passed to the plotting method}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor$plot()
backdoor$plot("v")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-tikz"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-tikz}{}}}
\subsection{Method \code{tikz()}}{
Return a TikZ code for drawing the DAG of the SCM object in LaTeX.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$tikz(
  subset = "uvr",
  layoutfunction = igraph::layout_with_lgl,
  labels = NULL,
  settings = list(force = FALSE, borders = TRUE, shape = "circle", size = 5, scale = 2),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subset}}{Variable groups to be plotted: "uvr","vr","uv", or "v".}

\item{\code{layoutfunction}}{A layout function from igraph package.}

\item{\code{labels}}{A named list that gives the names of vertices in TikZ.}

\item{\code{settings}}{A list with the following elements:}

\item{\code{...}}{Arguments to be passed to layoutfunction}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-pa"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-pa}{}}}
\subsection{Method \code{pa()}}{
Return the parents of a set of vertices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$pa(vnames, includeself = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vnames}}{A vector of vertex names}

\item{\code{includeself}}{Logical, should \code{vnames} to be included in the results (defaults TRUE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-ch"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-ch}{}}}
\subsection{Method \code{ch()}}{
Return the children of a set of vertices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$ch(vnames, includeself = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vnames}}{A vector of vertex names}

\item{\code{includeself}}{Logical, should \code{vnames} to be included in the results (defaults TRUE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-an"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-an}{}}}
\subsection{Method \code{an()}}{
Return the ancestors of a set of vertices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$an(vnames, includeself = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vnames}}{A vector of vertex names}

\item{\code{includeself}}{Logical, should \code{vnames} to be included in the results (defaults TRUE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-de"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-de}{}}}
\subsection{Method \code{de()}}{
Return the descendants of a set of vertices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$de(vnames, includeself = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vnames}}{A vector of vertex names}

\item{\code{includeself}}{Logical, should \code{vnames} to be included in the results (defaults TRUE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-add_variable"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-add_variable}{}}}
\subsection{Method \code{add_variable()}}{
Add a new variable to the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$add_variable(
  vfnew = NULL,
  ufnew = NULL,
  rfnew = NULL,
  rprefixnew = NULL,
  starsuffixnew = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vfnew}}{NULL or a named list containing the functions for the new observed variables.}

\item{\code{ufnew}}{NULL or a named list containing the functions for the new latent variables.}

\item{\code{rfnew}}{NULL or a named list containing the functions for the new missingness indicators.}

\item{\code{rprefixnew}}{NULL or the prefix of the missingness indicators.}

\item{\code{starsuffixnew}}{NULL orthe suffix for variables with missing data.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor2 <- backdoor$clone()
backdoor2$add_variable(
   vfnew = list(
             w = function(uw, x) {
             return(as.numeric(uw < 0.4 + 0.3*x))}),
   ufnew = list(
            uw = function(n) {return(stats::runif(n))})
) 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-remove_variable"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-remove_variable}{}}}
\subsection{Method \code{remove_variable()}}{
Remove variables from the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$remove_variable(variablenames)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variablenames}}{Names of the variables to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor2 <- backdoor$clone()
backdoor2$remove_variable(c("uy","y"))
#' @include R6causal.R R6causal_examples.R
NULL
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-causal.effect"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-causal.effect}{}}}
\subsection{Method \code{causal.effect()}}{
Is a causal effect identifiable from observational data?
Calls the implementation of ID algorithm from package \pkg{causaleffect}.
See the documentation of \code{\link[causaleffect]{causal.effect}} for the details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$causal.effect(y, x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{A vector of character strings specifying target variable(s).}

\item{\code{x}}{A vector of character strings specifying intervention variable(s).}

\item{\code{...}}{Other parameters passed to \code{\link[causaleffect]{causal.effect}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An expression for the joint distribution of the set of variables (y) given
the intervention on the set of variables (x) conditional on (z) if the effect is
 identifiable. Otherwise an error is thrown describing the graphical structure
 that witnesses non-identifiability.
 @examples
 backdoor$causal.effect(y = "y", x = "x")
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-dosearch"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-dosearch}{}}}
\subsection{Method \code{dosearch()}}{
Is a causal effect or other query identifiable from given data sources?
Calls \code{\link[dosearch]{dosearch}} from the package \pkg{dosearch}.
See the documentation of dosearch for the details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$dosearch(
  data,
  query,
  transportability = NULL,
  selection_bias = NULL,
  missing_data = NULL,
  control = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Character string specifying the data sources.}

\item{\code{query}}{Character string specifying the query of interest.}

\item{\code{transportability}}{Other parameters passed to \code{dosearch()}.}

\item{\code{selection_bias}}{Other parameters passed to \code{dosearch()}.}

\item{\code{missing_data}}{Other parameters passed to \code{dosearch()}.}

\item{\code{control}}{List of control parameters passed to \code{dosearch()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{dosearch}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor$dosearch(data = "p(x,y,z)", query = "p(y|do(x))")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-intervene"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-intervene}{}}}
\subsection{Method \code{intervene()}}{
Apply an intervention to the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$intervene(target, ifunction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{Name(s) of the variables in vflist to be intervened.}

\item{\code{ifunction}}{Either numeric value(s) or new structural function(s) for the target variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# A simple intervention
backdoor_x1 <- backdoor$clone()  # making a copy
backdoor_x1$intervene("x",1) # applying the intervention
backdoor_x1$plot() # to see that arrows incoming to x are cut

# An intervention that redefines a structural equation
backdoor_yz <- backdoor$clone()  # making a copy
backdoor_yz$intervene("y",
    function(uy, z) {return(as.numeric(uy < 0.1 + 0.8*z ))}) # making y a function of z only
backdoor_yz$plot() # to see that arrow x -> y is cut
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-simulate"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-simulate}{}}}
\subsection{Method \code{simulate()}}{
Simulate data from the SCM object.
Returns simulated data as a data.table and/or creates or updates \code{simdata} in the SCM object.
If \code{no_missing_data = FALSE}, creates or updates also \code{simdata_md}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$simulate(
  n = 1,
  no_missing_data = FALSE,
  seed = NULL,
  fixedvars = NULL,
  store_simdata = TRUE,
  return_simdata = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of observations to be generated.}

\item{\code{no_missing_data}}{Logical, should the generation of missing data skipped? (defaults FALSE).}

\item{\code{seed}}{NULL or a number for \code{set.seed}.}

\item{\code{fixedvars}}{List of variable names that remain unchanged or a data table/frame that contains the values of the fixed variables.}

\item{\code{store_simdata}}{Logical, should the simulated data to be stored in the SCM object (defaults TRUE)}

\item{\code{return_simdata}}{Logical, should the simulated data to be returned as the output (defaults FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor$simulate(8, return_simdata = TRUE, store_simdata = FALSE)
backdoor$simulate(10)
backdoor$simdata
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SCM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SCM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
