% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_risk_adjusted_returns.R
\name{plot_risk_adjusted_returns}
\alias{plot_risk_adjusted_returns}
\title{Plotting risk adjusted returns}
\usage{
plot_risk_adjusted_returns(
  safe_asset_return,
  risky_asset_return_mean,
  risky_asset_return_sd,
  risk_aversion = 2,
  current_risky_asset_allocation = NULL
)
}
\arguments{
\item{safe_asset_return}{A numeric.
The expected yearly return of the safe asset.}

\item{risky_asset_return_mean}{A numeric.
The expected (average) yearly return of the risky asset.}

\item{risky_asset_return_sd}{A numeric.
The standard deviation of the yearly returns of the risky asset.}

\item{risk_aversion}{A numeric.
The risk aversion coefficient.}

\item{current_risky_asset_allocation}{A numeric.
The current allocation to the risky asset.
For comparison with the optimal allocation.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plots the risk adjusted returns for portfolios
of various allocations to the risky asset.
}
\examples{
plot_risk_adjusted_returns(
  safe_asset_return              = 0.02,
  risky_asset_return_mean        = 0.04,
  risky_asset_return_sd          = 0.15,
  risk_aversion                  = 2,
  current_risky_asset_allocation = 0.8
)
}
\seealso{
\itemize{
\item \href{https://www.r4good.academy/en/blog/optimal-asset-allocation/index.en.html#how-much-risk-is-enough}{How to Determine Our Optimal Asset Allocation?}
\item Haghani V., White J. (2023) "The Missing Billionaires: A Guide to Better Financial Decisions." ISBN:978-1-119-74791-8.
}
}
