% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marray.R
\name{marray}
\alias{marray}
\title{m-array: table of first recaptures}
\usage{
marray(X, freq)
}
\arguments{
\item{X}{a matrix of encounter histories over K occasions}

\item{freq}{is a vector with the number of individuals having the corresponding encounter history}
}
\value{
This function returns a list with R the number of released individuals (K-1 x g matrix), m the m-array (K-1 x K-1 x g array) with upper triangle filled only and never the number of individuals never recaptured (K-1 x g matrix).
}
\description{
This function calculates the m-array, the number of released and never seen again individuals; deals with more than 1 group
}
\examples{
# read in the classical dipper dataset
dipper = system.file("extdata", "ed.inp", package = "R2ucare")
dipper = read_inp(dipper,group.df=data.frame(sex=c('Male','Female')))

# Get encounter histories, counts and groups:
dip.hist = dipper$encounter_histories
dip.freq = dipper$sample_size
dip.group = dipper$groups

# get female data
mask = (dip.group == 'Female')
dip.fem.hist = dip.hist[mask,]
dip.fem.freq = dip.freq[mask]

# get number of released individuals (R), 
# the m-array (m) and 
# the number of individuals never seen again (never)
marray(dip.fem.hist,dip.fem.freq)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>,Jean-Dominique Lebreton, Rémi Choquet, Roger Pradel
}
\keyword{package}
