% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_JMV.R
\name{overall_JMV}
\alias{overall_JMV}
\title{Overall goodness-of-fit test for the Jolly-Move model}
\usage{
overall_JMV(X, freq, rounding = 3)
}
\arguments{
\item{X}{is a matrix of encounter histories}

\item{freq}{is a vector of the number of individuals with the corresponding encounter history}

\item{rounding}{is the level of rounding for outputs; default is 3}
}
\value{
This function returns a data.frame with the value of the test statistic, the degrees of freedom and the p-value of the test.
}
\description{
This function performs the overall goodness-of-fit test for the Jolly-Move model.
It is obtained as the sum of the 5 components Test3G.SR, Test3G.SM, Test3G.WBWA, TestM.ITEC, TestM.LTEC.
To perform the goodness-of-fit test for the Arnason-Schwarz model, both the Arnason-Schwarz (AS) and the Jolly-Move models need to be fitted to the data (to our knowledge, only E-SURGE can fit the JMV model).
Assuming the overall goodness-of-fit test for the JMV model has produced the value stat_jmv for the test statistic,
get the deviance (say dev_as and dev_jmv) and number of estimated parameters (say dof_as and dof_jmv) for both the AS and JMV models.
Then, finally, the p-value of the goodness-of-fit test for the AS model is obtained as 1 - pchisq(stat_as,dof_as) where stat_as = stat_jmv + (dev_as - dev_jmv) and dof_as = dof_jmv + (dof_jmv - dof_as)
}
\examples{
\dontrun{
# read in Geese dataset
library(RMark)
geese = system.file("extdata", "geese.inp", package = "R2ucare")
geese = convert.inp(geese)

geese.hist = matrix(as.numeric(unlist(strsplit(geese$ch, ''))),nrow=nrow(geese),byrow=TRUE)
geese.freq = geese$freq

# encounter histories and number of individuals with corresponding histories
X = geese.hist
freq = geese.freq

# load R2ucare package
library(R2ucare)

# perform overall gof test
overall_JMV(X, freq)
}
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>, Roger Pradel, Rémi Choquet
}
\keyword{package}

