\name{bugs.script}
\alias{bugs.script}
\title{Writes script for running WinBUGS - intended for internal use only}
\description{Write file \file{script.txt} for WinBUGS to read - intended for internal use only}
\usage{
bugs.script(parameters.to.save, n.chains, n.iter, n.burnin, n.thin, 
    bugs.directory, model.file, debug = FALSE, is.inits, bin, 
    DIC = FALSE, useWINE = FALSE, newWINE = FALSE)
}
\arguments{
  \item{parameters.to.save}{parameters that should be monitored}
  \item{n.chains}{number of Markov chains}
  \item{n.iter}{number of total iterations (including burn in)}
  \item{n.burnin}{length of burn in}
  \item{n.thin}{size of thinning parameter}
  \item{bugs.directory}{directory that contains the WinBUGS executable}  
  \item{model.file}{file containing the model written in WinBUGS code}
  \item{debug}{if \code{FALSE}, WinBUGS is closed automatically, 
    otherwise WinBUGS remains open for further investigation}
  \item{is.inits}{logical; whether initial values are given by the user (\code{TRUE}) 
    or have to be generated by WinBUGS}
  \item{bin}{number of iterations between saving of results}
  \item{DIC}{logical; if \code{TRUE}, compute deviance, pD, and DIC automatically in WinBUGS}
  \item{useWINE}{logical; use WINE to run WinBUGS under Linux}
  \item{newWINE}{set this one to \code{TRUE} for new versions of WINE.} 
}
\value{
    Does not return anything.
}
\seealso{The main function to be called by the user is \code{\link{bugs}}.}
\keyword{internal}

