% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_workflows.R
\name{flFit}
\alias{flFit}
\title{Perform a fluorescence curve analysis on all samples in the provided dataset.}
\usage{
flFit(
  fl_data,
  time = NULL,
  growth = NULL,
  control = fl.control(),
  parallelize = TRUE,
  ...
)
}
\arguments{
\item{fl_data}{Either... \enumerate{ \item a \code{grodata} object created with \code{\link{read_data}} or \code{\link{parse_data}},
\item a list containing a \code{'time'} matrix (for x_type == "time") or \code{'growth'} dataframe (for x_type == "growth") and a \code{'fluorescence'} dataframes,
or \item a dataframe containing (normalized) fluorescence values (if a \code{time} matrix or \code{growth} dataframe is provided as separate argument).}}

\item{time}{(optional) A matrix containing time values for each sample.}

\item{growth}{(optional) A dataframe containing growth values for each sample and sample identifiers in the first three columns.}

\item{control}{A \code{fl.control} object created with \code{\link{fl.control}}, defining relevant fitting options.}

\item{parallelize}{Run linear fits and bootstrapping operations in parallel using all but one available processor cores}

\item{...}{Further arguments passed to the shiny app.}
}
\value{
An \code{flFit} object that contains all fluorescence fitting results, compatible with
various plotting functions of the QurvE package.
\item{raw.x}{Raw x matrix passed to the function as \code{time} (for x_type = 'time') or \code{growth} (for x_type = 'growth').}
\item{raw.fl}{Raw growth dataframe passed to the function as \code{data}.}
\item{flTable}{Table with fluorescence parameters and related statistics for each fluorescence curve evaluation performed by the function. This table, which is also returned by the generic \code{summary.flFit} method applied to a \code{flFit} object, is used as an input for \code{\link{fl.drFit}}.}
\item{flFittedLinear}{List of all \code{flFitLinear} objects, generated by the call of \code{\link{flFitLinear}}. Note: access to each object in the list via double brace: flFittedLinear[[#n]].}
\item{flFittedSplines}{List of all \code{flFitSpline} objects, generated by the call of \code{\link{flFitSpline}}. Note: access to each object via double brace: flFittedSplines[[#n]].}
\item{flBootSplines}{List of all \code{flBootSpline} objects, generated by the call of \code{\link{flBootSpline}}. Note: access to each object via double brace: flFittedSplines[[#n]].}
\item{control}{Object of class \code{fl.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{flFit} performs all computational fluorescence fitting operations based on the user input.
}
\details{
Common response parameters used in dose-response analysis:\if{html}{\out{<br>}}\if{html}{\out{<br>}}\if{html}{\out{<b>}}Linear fit:\if{html}{\out{</b>}}\if{html}{\out{<br>}}- max_slope.linfit: Fluorescence increase rate\if{html}{\out{<br>}}- lambda.linfit: Lag time\if{html}{\out{<br>}}- dY.linfit: Maximum Fluorescence - Minimum Fluorescence\if{html}{\out{<br>}}- A.linfit: Maximum fluorescence\if{html}{\out{<br>}}\if{html}{\out{<br>}}\if{html}{\out{<b>}}Spline fit:\if{html}{\out{</b>}}\if{html}{\out{<br>}}- max_slope.spline: Fluorescence increase rate\if{html}{\out{<br>}}- lambda.spline: Lag time\if{html}{\out{<br>}}- dY.spline: Maximum Fluorescence - Minimum Fluorescence\if{html}{\out{<br>}}- A.spline: Maximum fluorescence\if{html}{\out{<br>}}- integral.spline: Integral\if{html}{\out{<br>}}\if{html}{\out{<br>}}\if{html}{\out{<b>}}Parametric fit:\if{html}{\out{</b>}}\if{html}{\out{<br>}}- max_slope.model: Fluorescence increase rate\if{html}{\out{<br>}}- lambda.model: Lag time\if{html}{\out{<br>}}- dY.model: Maximum Fluorescence - Minimum Fluorescence\if{html}{\out{<br>}}- A.model: Maximum fluorescence\if{html}{\out{<br>}}- integral.model: Integral'
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t" )

# Define fit controls
control <- fl.control(fit.opt = "s",
             x_type = "time", norm_fl = TRUE,
             dr.parameter = "max_slope.spline",
             dr.method = "model",
             suppress.messages = TRUE)

# Run curve fitting workflow
res <- flFit(fl_data = input$norm.fluorescence,
             time = input$time,
             control = control,
             parallelize = FALSE)

summary(res)

}
\seealso{
Other workflows: 
\code{\link{growth.gcFit}()},
\code{\link{growth.workflow}()}

Other fluorescence fitting functions: 
\code{\link{flBootSpline}()},
\code{\link{flFitSpline}()}

Other dose-response analysis functions: 
\code{\link{growth.drBootSpline}()},
\code{\link{growth.drFitSpline}()},
\code{\link{growth.gcFit}()},
\code{\link{growth.workflow}()}
}
\concept{dose-response analysis functions}
\concept{fluorescence fitting functions}
\concept{workflows}
