% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx_constraint.R
\name{user_constraint}
\alias{user_constraint}
\title{Formalize User-Specified Constraint of \linkS4class{fmx} Object}
\usage{
user_constraint(x, distname, K)
}
\arguments{
\item{x}{\link[base]{character} \link[base]{vector}, constraint(s) to be imposed.
For example, for a two-component Tukey's \eqn{g}-&-\eqn{h}
mixture, \code{c('g1', 'h2')} indicates \eqn{g_1=h_2=0} given \eqn{A_1 < A_2}, i.e., the
\eqn{g}-parameter for the first component (with smaller location value)
and the \eqn{h}-parameter for the second component (with larger mean value) are to be constrained as 0.}

\item{distname}{\link[base]{character} scalar, name of distribution}

\item{K}{\link[base]{integer} scalar, number of components}
}
\value{
\link{user_constraint} returns the indices of internal parameters
(only applicable to Tukey's \eqn{g}-&-\eqn{h} mixture distribution, yet) to be constrained,
based on the type of distribution \code{distname}, number of components \code{K}
and a user-specified string (e.g., \code{c('g2', 'h1')}).
}
\description{
Formalize user-specified constraint of \linkS4class{fmx} object
}
\examples{
(d0 = fmx('GH', A = c(1,4), g = c(.2,.1), h = c(.05,.1), w = c(1,1)))
(c0 = fmx_constraint(d0))
user_constraint(distname = 'GH', K = 2L, x = character()) # equivalent

(d1 = fmx('GH', A = c(1,4), g = c(.2,0), h = c(0,.1), w = c(1,1)))
(c1 = fmx_constraint(d1))
user_constraint(distname = 'GH', K = 2L, x = c('g2', 'h1')) # equivalent

(d2 = fmx('GH', A = c(1,4), g = c(.2,0), h = c(.15,.1), w = c(1,1)))
(c2 = fmx_constraint(d2))
user_constraint(distname = 'GH', K = 2L, x = 'g2') # equivalent

}
