% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqfeed.R
\name{iqfeed}
\alias{iqfeed}
\title{IQFeed}
\description{
IQFeed
}
\details{
Retrieves IQFeed historical market data like ticks and candles.

Valid basis_for_last values:
\tabular{lll}{
C \tab Last Qualified Trade                                  \cr
E \tab Extended Trade = Form T trade                         \cr
O \tab Other Trade = Any trade not accounted for by C or E.  \cr
S \tab Settle = Daily settle, only applicable to commodities.\cr
}

Valid trade_conditions:
\tabular{lll}{
01 \tab REGULAR         \tab Normal Trade                                                                              \cr
10 \tab SOLDLAST        \tab Sold Last (late reporting)                                                                \cr
11 \tab NEXTDAYCLR      \tab Next Day Clearing                                                                         \cr
12 \tab LATEREP         \tab Opened  Late Report of Opening Trade (in or out of sequence)                              \cr
13 \tab PRP             \tab Prior Reference Price                                                                     \cr
14 \tab SELLER          \tab Seller                                                                                    \cr
15 \tab SPLIT           \tab Split Trade                                                                               \cr
16 \tab RSVD            \tab (Reserved)                                                                                \cr
17 \tab FORMT           \tab FormT Trade                                                                               \cr
18 \tab CSTMBSKTX       \tab Custom Basket Cross                                                                       \cr
19 \tab SOLDOSEQ        \tab Sold Out of Sequence                                                                      \cr
1a \tab CANC            \tab Cancelled Previous Transaction                                                            \cr
1b \tab CANCLAST        \tab Cancelled Last Transaction                                                                \cr
1c \tab CANCOPEN        \tab Cancelled Open Transaction                                                                \cr
1d \tab CANCONLY        \tab Cancelled Only Transaction                                                                \cr
1e \tab OPEN            \tab Late Report of Opening Trade  out of sequence                                             \cr
1f \tab OPNL            \tab Late Report of Opening Trade  in correct sequence                                         \cr
02 \tab ACQ             \tab Acquisition                                                                               \cr
20 \tab AUTO            \tab Transaction Executed Electronically                                                       \cr
21 \tab HALT            \tab Halt                                                                                      \cr
22 \tab DELAYED         \tab Delayed                                                                                   \cr
23 \tab NONBOARDLOT     \tab                                                                                           \cr
24 \tab POSIT           \tab                                                                                           \cr
25 \tab REOP            \tab Reopen After Halt                                                                         \cr
26 \tab AJST            \tab Contract Adjustment for Stock Dividend  Split  etc.                                       \cr
27 \tab SPRD            \tab Spread  Trade in Two Options in the Same Class (a buy and a sell in the same class)       \cr
28 \tab STDL            \tab Straddle  Trade in Two Options in the Same Class (a buy and a sell in a put and a call)   \cr
29 \tab STPD            \tab Follow a Nonstopped Trade                                                                 \cr
2a \tab CSTP            \tab Cancel Stopped Transaction                                                                \cr
2b \tab BWRT            \tab Option Portion of a Buy/Write                                                             \cr
2c \tab CMBO            \tab Combo  Trade in Two Options in the Same Options Class (a buy and a sell in the same class)\cr
2d \tab UNSPEC          \tab Unspecified                                                                               \cr
2e \tab MCOFCLCLOSE     \tab Market Center Official Closing Price                                                      \cr
2f \tab STPDREGULAR     \tab Stopped Stock  Regular Trade                                                              \cr
03 \tab CASHM           \tab Cash Only Market                                                                          \cr
30 \tab STPDSOLDLAST    \tab Stopped Stock  Sold Last                                                                  \cr
31 \tab STPDSOLDOSEQ    \tab Stopped Stock  Sold out of sequence                                                       \cr
32 \tab BASIS           \tab Basis                                                                                     \cr
33 \tab VWAP            \tab VolumeWeighted Average Price                                                              \cr
34 \tab STS             \tab Special Trading Session                                                                   \cr
35 \tab STT             \tab Special Terms Trading                                                                     \cr
36 \tab CONTINGENT      \tab Contingent Order                                                                          \cr
37 \tab INTERNALX       \tab Internal Cross                                                                            \cr
38 \tab MOC             \tab Market On Close Trade                                                                     \cr
39 \tab MCOFCLOPEN      \tab Market Center Official Opening Price                                                      \cr
3a \tab FORTMTSOLDOSEQ  \tab FormT Sold Out of Sequence                                                                \cr
3b \tab YELLOWFLAG      \tab Yellow Flag                                                                               \cr
3c \tab AUTOEXEC        \tab Auto Execution                                                                            \cr
3d \tab INTRMRKSWEEP    \tab Intramaket Sweep                                                                          \cr
3e \tab DERIVPRI        \tab Derivately Priced                                                                         \cr
3f \tab REOPNING        \tab ReOpeing Prints                                                                           \cr
04 \tab BUNCHED         \tab Bunched Trade                                                                             \cr
40 \tab CLSING          \tab Closing Prints                                                                            \cr
41 \tab CAPELCTN        \tab CAP (Conversion and Parity) election trade                                                \cr
42 \tab CROSSTRADE      \tab Cross Trade                                                                               \cr
43 \tab PRICEVAR        \tab Price Variation                                                                           \cr
44 \tab STKOPTTRADE     \tab StockOption Trade                                                                         \cr
45 \tab SPIM            \tab stopped at price that did not constitute a TradeThrough                                   \cr
46 \tab BNMT            \tab Benchmark Trade                                                                           \cr
47 \tab TTEXEMPT        \tab Transaction is Trade Through Exempt                                                       \cr
48 \tab LATE            \tab Late Market                                                                               \cr
49 \tab XCHGPHYSICAL    \tab Exchange for Physical                                                                     \cr
4a \tab CABINET         \tab Cabinet                                                                                   \cr
4b \tab DIFFERENTIAL    \tab Differential                                                                              \cr
4c \tab HIT             \tab Hit                                                                                       \cr
4d \tab IMPLIED         \tab Implied                                                                                   \cr
4e \tab LGORDER         \tab Large Order                                                                               \cr
4f \tab SMORDER         \tab Small Order                                                                               \cr
05 \tab AVGPRI          \tab Average Price Trade                                                                       \cr
50 \tab MATCH           \tab Match/Cross Trade                                                                         \cr
51 \tab NOMINAL         \tab Nominal                                                                                   \cr
52 \tab OPTIONEX        \tab Option Exercise                                                                           \cr
53 \tab PERCENTAGE      \tab Percentage                                                                                \cr
54 \tab AUTOQUOTE       \tab Auto Quotes                                                                               \cr
55 \tab INDICATIVE      \tab Indicative                                                                                \cr
56 \tab TAKE            \tab Take                                                                                      \cr
57 \tab NOMINALCABINET  \tab Nominal Cabinet                                                                           \cr
58 \tab CHNGTRANSACTION \tab Changing Transaction                                                                      \cr
59 \tab CHNGTRANSCAB    \tab Changing Transaction Cabinet                                                              \cr
5a \tab FAST            \tab Fast Market (ssfutures)                                                                   \cr
5b \tab NOMINALUPDATE   \tab Nominal Update                                                                            \cr
5c \tab INACTIVE        \tab Inactive  Nominal  No Trade                                                               \cr
5d \tab DELTA           \tab Last Trade with Delta Exchange                                                            \cr
5e \tab ERRATIC         \tab Erratic                                                                                   \cr
5f \tab RISKFACTOR      \tab Risk Factor                                                                               \cr
06 \tab CASH            \tab Cash Trade (same day clearing)                                                            \cr
60 \tab OPTADDON        \tab Short Option AddOn                                                                        \cr
61 \tab VOLATILITY      \tab Volatility Trade                                                                          \cr
62 \tab SPDRPT          \tab Spread Reporting                                                                          \cr
63 \tab VOLADJ          \tab Volume Adjustment                                                                         \cr
64 \tab BLANK           \tab Blank out associated price                                                                \cr
65 \tab SOLDLATE        \tab Late report of transaction  in correct sequence                                           \cr
66 \tab BLKT            \tab Block Trade                                                                               \cr
67 \tab EXPH            \tab Exchange Future for Physical                                                              \cr
68 \tab SPECIALISTA     \tab Ask from specialist Book                                                                  \cr
69 \tab SPECIALISTB     \tab Bid from specialist Book                                                                  \cr
6a \tab SPECIALISTBA    \tab Both Bid and Ask from Specialist Book                                                     \cr
6b \tab ROTATION        \tab Rotation                                                                                  \cr
6c \tab HOLIDAY         \tab Holiday                                                                                   \cr
6d \tab PREOPENING      \tab Pre Opening                                                                               \cr
6e \tab POSTFULL        \tab Post Full                                                                                 \cr
6f \tab POSTRESTRICTED  \tab Post Restricted                                                                           \cr
07 \tab DIST            \tab Distribution                                                                              \cr
70 \tab CLOSINGAUCTION  \tab Closing Auction                                                                           \cr
71 \tab BATCH           \tab Batch                                                                                     \cr
72 \tab TRADING         \tab Trading                                                                                   \cr
73 \tab OFFICIAL        \tab Official Bid/Ask price                                                                    \cr
74 \tab UNOFFICIAL      \tab Unofficial Bid/Ask price                                                                  \cr
75 \tab MIDPRICE        \tab Midprice last                                                                             \cr
76 \tab FLOOR           \tab Floor B/A price                                                                           \cr
77 \tab CLOSE           \tab Closing Price                                                                             \cr
78 \tab HIGH            \tab End of Session High Price                                                                 \cr
79 \tab LOW             \tab End of Session Low Price                                                                  \cr
7a \tab BACKWARDATION   \tab Backwardation  immediate delivery costing more than future delivery                       \cr
7b \tab CONTANGO        \tab Contango  future delivery costing more than immediate delivery                            \cr
7c \tab RFSETTLEMENT    \tab Refined Fuel Spot Settlement                                                              \cr
7d \tab RFRESERVED1     \tab Refined Fuel Spot Reserved  1                                                             \cr
7e \tab RFRESERVED2     \tab Refined Fuel Spot Reserved  2                                                             \cr
7f \tab RFRESERVED3     \tab Refined Fuel Spot Reserved  3                                                             \cr
08 \tab NEXTDAY         \tab Next Day Market                                                                           \cr
80 \tab RFRESERVED4     \tab Refined Fuel Spot Reserved  4                                                             \cr
81 \tab YIELD           \tab Yield Price                                                                               \cr
82 \tab BASISHIGH       \tab Current Basis High Value                                                                  \cr
83 \tab BASISLOW        \tab Current Bases Low Value                                                                   \cr
84 \tab UNCLEAR         \tab bid or offer price is unclear                                                             \cr
85 \tab OTC             \tab Over the counter trade                                                                    \cr
86 \tab MS              \tab Trade entered by Market Supervision                                                       \cr
87 \tab ODDLOT          \tab Odd lot trade                                                                             \cr
88 \tab CORRCSLDLAST    \tab Corrected Consolidated last                                                               \cr
09 \tab BURSTBSKT       \tab Burst Basket Execution                                                                    \cr
0a \tab BUNCHEDSOLD     \tab Bunched Sold Trade                                                                        \cr
0b \tab ORDETAIL        \tab Opening/Reopening Trade Detail                                                            \cr
0c \tab INTERDAY        \tab Intraday Trade Detail                                                                     \cr
0d \tab BSKTONCLOSE     \tab Basket Index on Close                                                                     \cr
0e \tab RULE127         \tab Rule  127 Trade NYSE                                                                      \cr
0f \tab RULE155         \tab Rule  155 Trade AMEX
}
}
\examples{
\donttest{
symbol = 'MSFT'
to = format( Sys.time() )
from = format( Sys.time() - as.difftime( 3, units = 'days' ) )
days = 10
# ticks
get_iqfeed_data( symbol, from, to, 'tick' )
# candles
get_iqfeed_data( symbol, from, to, '1min' )
# daily candles
get_iqfeed_data( symbol, from, to )
}

}

