% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{coupons}
\alias{coupons}
\title{Coupon payment calculation}
\usage{
coupons(
  dates = NULL,
  coupon.rate,
  principal = 1,
  asset.type = "TES",
  freq = NULL,
  daycount = "ACT/360",
  loc = "BOG",
  maturity = NULL,
  analysis.date = Sys.Date(),
  trade.date = NULL,
  coupon.schedule = "SF"
)
}
\arguments{
\item{dates}{Coupon payment dates.}

\item{coupon.rate}{Coupon rate of the asset. Can be an unique numeric
value or a vector corresponding to each coupon payment date.}

\item{principal}{Notional amount for the asset.}

\item{asset.type}{String that determines the asset type to value. See also
'Details'.}

\item{freq}{Frequency of payments of a given asset in a year. For LIBOR and
IBR the default frequency is four (quarterly payments). TES has a default
frequency of one (annual payments).}

\item{daycount}{Day count convention. See also 'Details'.}

\item{loc}{String related to the location of the asset. It is used to
calculate the effective dates, taking into account the business days
of the given location. See also 'Details'.}

\item{maturity}{Only necessary in cases where coupon payment dates are not provided in the \code{dates} parameter.
Last day of the contract. Can be a numeric value that represents the duration of the contract in years.}

\item{analysis.date}{Date in which the asset is valued. By default, the
current date.}

\item{trade.date}{The date on which the transaction occurs. It is used to calculate
maturity as a date, when given in years. Also required for non-trivial cases such as
bonds with long first coupon.}

\item{coupon.schedule}{String that establishes if a bond first coupon period is a long
first coupon or a short first coupon. On the contrary, establishes if last coupon period
is long last coupon or a short last coupon. See also 'Details'.}
}
\value{
$Coupons or $Cash flows of the asset in analysis.
}
\description{
Function that returns coupon values according to specified payment dates and
a day count convention. Yields the values of cash flows for the remaining
duration of assets, following a date payment structure, face value -or
principal- and a specified coupon rate.
}
\details{
\code{asset.type} makes reference to the following type of assets:
\itemize{
   \item "TES" for Colombian Treasury Bonds (default).
   \item "FixedIncome" for assets that are indexed to a fixed income with
   different frequency of payments.
   \item "IBR" for bonds and assets indexed to 3M IBR rate.
   \item "IBRSwaps" for swaps indexed to IBR rate.
   \item "LIBOR" for bonds and assets indexed to 3M LIBOR.
   \item "UVRSwaps" for cross-currency swaps indexed to UVR-IBR rate.
   \item "LIBORSwaps" for Interest Rate Swaps (IRS) indexed to 3M LIBOR.
     }

\code{daycount} convention accepts the following values:
\itemize{
    \item 30/360.
    \item ACT/365.
    \item ACT/360 (Default).
    \item ACT/365L.
    \item NL/365.
    \item ACT/ACT-ISDA
    \item ACT/ACT-AFB
}

\code{coupon.schedule} makes reference to the following type of coupon payment schedule
of a bond:
\itemize{
   \item "LF" for Long First coupon payment.
   \item "LL" for Long Last coupon payment.
   \item "SF" for Short First coupon payment.
   \item "SL" for Short Last coupon payment.
     }
}
\examples{
coupons(dates = c("2020-09-10", "2020-12-10", "2021-03-10"),
        coupon.rate = 0.06)
coupons(dates = c("2020-09-10", "2020-12-10", "2021-03-10"),
        coupon.rate = 0.08, principal = 1000,
        asset.type = "LIBOR", daycount = "ACT/365")
coupons(dates = c("2020-09-10","2020-12-10", "2021-03-10"),
        coupon.rate = 0.07, asset.type = "FixedIncome",
        freq = 4, daycount = "NL/365")
coupons(coupon.rate = c(0.04,0.04,0.42,0.045,0.05),
        maturity = "2024-01-05", analysis.date = "2023-01-03",
        asset.type = "IBR")
coupons(coupon.rate = 0.03, maturity = 1.08,
        analysis.date = "2020-02-29", trade.date = "2020-02-29",
        asset.type = "IBR", coupon.schedule = "LF")

}
