% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{kb.test-class}
\alias{kb.test-class}
\title{An S4 class for kernel-based distance tests with normal kernel}
\description{
A class to represent the results of Gaussian kernel-based
quadratic distance tests. This includes the normality test, the two-sample
test statistics and the k-sample tests.
}
\section{Slots}{

\describe{
\item{\code{method}}{String indicating the normal kernel-based quadratic distance
test performed.}

\item{\code{Un}}{The value of the test U-statistics.}

\item{\code{Vn}}{The value of the test V-statistic.}

\item{\code{H0_Un}}{A logical value indicating whether or not the null hypothesis is
rejected according to U-statistics.}

\item{\code{H0_Vn}}{A logical value indicating whether or not the null hypothesis is
rejected according to Vn.}

\item{\code{data}}{List of samples X (and Y).}

\item{\code{CV_Un}}{The critical value computed for the test Un.}

\item{\code{CV_Vn}}{The critical value computed for the test Vn.}

\item{\code{cv_method}}{The method used to estimate the critical value (one of
"subsampling", "permutation" or "bootstrap").}

\item{\code{h}}{A list with the value of bandwidth parameter used for the Gaussian
kernel. If the function \code{select_h} is used, then also the matrix
of computed power values and the resulting power plot are provided.}

\item{\code{B}}{Number of bootstrap/permutation/subsampling replications.}

\item{\code{var_Un}}{exact variance of the kernel-based U-statistic.}
}}

\examples{
# create a kb.test object
x <- matrix(rnorm(100),ncol=2)
y <- matrix(rnorm(100),ncol=2)
# Normality test
kb.test(x, h=0.5)

# Two-sample test
kb.test(x,y,h=0.5, method="subsampling",b=0.9)

}
