% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterQp.R
\name{clusterQp}
\alias{clusterQp}
\title{Cluster-Specific Sample Quantiles}
\usage{
clusterQp(
  formula,
  data,
  exclude,
  from = 0.01,
  to = 0.99,
  by = 0.01,
  type = 7,
  ...
)
}
\arguments{
\item{formula}{\link[stats]{formula} passed to \link[stats]{aggregate.formula}.
To calculate the cluster-specific statistics
for response \eqn{y}, the user may use
\describe{
\item{\code{y ~ id}}{to retain only the cluster \code{id} in the returned value}
\item{\code{y ~ id + x1 + x2}}{to retain the cluster \code{id} and cluster-specific variables \eqn{x_1} and \eqn{x_2} in the returned value}
\item{\code{y ~ .}}{to retain all (supposedly cluster-specific) variables from \code{data} in the returned value}
}}

\item{data}{\link[base]{data.frame}}

\item{exclude}{(optional) \link[stats]{formula} or \link[base]{character} \link[base]{vector},
(supposedly non-cluster-specific) variables to be excluded from aggregation.
To remove variables \eqn{z_1} and \eqn{z_2}, the user may use either
\itemize{
\item \code{exclude = c('z1', 'z2')}; or
\item \code{exclude = . ~ . - z1 - z2}
}}

\item{from, to, by}{\link[base]{double} scalars,
the starting, end, and increment values
to specify a \link[base]{seq}uence of probabilities
\eqn{p = (p_1,\cdots,p_N)'}
for the sample \link[stats]{quantile}s \eqn{q = (q_1,\cdots,q_N)'}}

\item{type}{\link[base]{integer} scalar, type of \link[stats]{quantile} algorithm}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=clusterQp]{clusterQp()}} returns an \link[stats]{aggregate}d \link[base]{data.frame}.
A \link[base]{double} \link[base]{matrix} of \eqn{N} columns is created to store
the sample \link[stats]{quantile}s \eqn{q} of each \link[stats]{aggregate}d cluster.
The column names of this quantile \link[base]{matrix} are the probabilities \eqn{p}.
}
\description{
Obtain vectors of sample \link[stats]{quantile}s in each cluster of observations
}
\details{
Function \code{\link[=clusterQp]{clusterQp()}} calculates \eqn{N} sample \link[stats]{quantile}s
in each \link[stats]{aggregate}d cluster of observations.
The aggregation is specified by parameters \code{formula} and \code{exclude}.
}
\examples{
Ki67q = clusterQp(Marker ~ ., data = Ki67, exclude = c('tissueID','inner_x','inner_y'))
tmp = clusterQp(Marker ~ ., data = Ki67, exclude = . ~ . - tissueID - inner_x - inner_y)
# stopifnot(identical(Ki67q, tmp))
# stopifnot(!anyDuplicated.default(Ki67q$subjID))
head(Ki67q)
sapply(Ki67q, FUN = class)

}
