% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optQp.R
\name{eval_dichotom}
\alias{eval_dichotom}
\title{Optimal Quantile Predictor}
\usage{
eval_dichotom(formula, data, seeds, pct_train = 0.8, ...)
}
\arguments{
\item{formula}{\link[stats]{formula}, supports \link[survival]{Surv}, \link[base]{logical}, or \link[base]{numeric} endpoint
and one \link[base]{matrix} predictor of the descriptive statistics of markers per cluster.
See details of parameter \code{data}.}

\item{data}{\link[base]{data.frame}, with at least
\itemize{
\item {two \link[survival]{Surv} columns including time-to-event and event indicator,
one \link[base]{logical} column,
or one \link[base]{numeric} column as the outcome}
\item {one \link[base]{matrix} column as the descriptive statistics of markers per cluster.
Currently only a quantile sequence is supported.}
}}

\item{seeds}{\link[base]{integer} vector of random seeds for generating repeated random split samples, see \link[base]{set.seed}}

\item{pct_train}{\link[base]{numeric} scalar, proportion of the training set, default \code{.8}}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{eval_dichotom} returns a \link{eval_dichotom} object, which is a \link[base]{list} with elements  elements
\code{thresholds} and \code{coefs}.
\describe{
\item{\code{thresholds}}{\link[base]{matrix}, data set with all cut points for all candidate quantiles and Np columns and Nsplit rows }
\item{\code{coefs}}{\link[base]{matrix}, coefficients corresponding to thresholds}
\item{\code{data}}{\link[base]{data.frame}, this is the unmodified input \code{data}}
}
}
\description{
From a given set of sample quantiles, this function selects the optimal quantile
with the largest effect size for predicting given \link[survival]{Surv},
\link[base]{logical}, or \link[base]{numeric} outcome
}
\details{
Optimal quantile selection algorithm
For a sample \eqn{x_i ,1 \leq i \leq n} of repeated measures of independent variable \eqn{X}
and probability \eqn{p, 0 < p < 1},
the empirical quantile function \eqn{Q_n(p)} is defined as the k th order statistic of the sample,
where \eqn{k} is such that \eqn{(k-1)/n < p < k/n}. For \eqn{p = .01,\cdots,.99} and \eqn{k = 100p},
\eqn{Q_n(p)} is also known as \eqn{k}th percentile.
The following algorithm is proposed to identify the optimal \eqn{Q(p)} predictor of
survival outcome in a screening data set:

\enumerate{

\item Select the set of quantiles to be evaluated as predictors and the desired ratio
for training/test sets.

\item Split the data into training and test sets
\itemize{
\item In case of \link[survival]{Surv} outcomes, split the group of subjects with event into a training set and a test set randomly
with desired ratio. Similarly, split the group of subjects without event into a training
set and a test set randomly with desired ratio. Combine training sets with and
without event and test sets with and without event.
\item In case of \link[base]{logical} outcomes, split the group of subjects with one level of outcome into a training set and a test set randomly
with desired ratio. Similarly, split the group of subjects with the other level of outcome into a training
set and a test set randomly with desired ratio. Combine training sets with both levels of logical outcome and test sets with both levels of logical outcome.
\item In case of \link[base]{numeric} outcomes, split the entire subjects into a training set and a test set randomly
with desired ratio.
}

\item For each training/test set pair and each considered quantile,
\itemize{
\item Determine the optimal cutoff (e.g. using the R package rpart) in the combined
training set.
\item Apply the optimal cutoff to the combined test set and estimate the effect size
(hazard ratio, odds ratio, or exponentiated coefficient).
}

\item Repeat steps 2 and 3 for 100 training/test splits, compute the median log effect size
(log hazard ratio(HR), log odds ratio(OR), or coefficient) for each quantile.

\item Rank the effect sizes (absolute value of log OR, HR, or coefficient) for all considered quantiles and
select the optimal quantile with the highest effect size.

\item Perform bootstrap-based optimism correction for the selected optimal quantile(s).
In this work, for each random split, \eqn{80\%} of subjects were assigned to the training
set and \eqn{20\%} of subjects were assigned to the test set. We considered every fifth
quantile starting from the 5th quantile to the 95th quantile plus 99th quantile as
candidate predictors of PFS (a total of 20 quantile predictors). Also, we identified
quantiles with the second and third highest effect sizes to compare them to the
optimal ones.
}
}
\examples{

if (FALSE) { # masked to save time
library(survival)

Ki67_Qps = sampleQp(data = Ki67, subjID = 'PATIENT_ID', 
  exclude = c('tissueID','inner_x','inner_y'), Qpredictor = 'Marker')
Ki67c = eval_dichotom(Surv(RECFREESURV_MO, RECURRENCE) ~ Marker, data = Ki67_Qps, 
  seeds = 1:20)
# summary(Ki67c) # works, but not needed
head(Ki67_opt <- optQp(Ki67c, n = 2L))

set.seed(1)
mod_c = BBC_dichotom(Surv(RECFREESURV_MO, RECURRENCE) ~ NodeSt + Tstage, 
  data = optQp(Ki67c, n = 2L), contX = 'Marker', R = 100)
summary(mod_c)
}

if (FALSE) { # mask to save time
Ki67a = eval_dichotom(RECFREESURV_MO ~ Marker, data = Ki67_Qps, seeds = 1:20)
set.seed(1)
mod_a = BBC_dichotom(RECFREESURV_MO ~ NodeSt + Tstage, data = optQp(Ki67a, n = 2L), 
  contX = 'Marker', R = 100)
summary(mod_a)

Ki67b = eval_dichotom(RECURRENCE ~ Marker, data = Ki67_Qps, seeds = 1:20)
set.seed(1)
mod_b = BBC_dichotom(RECURRENCE ~ NodeSt + Tstage, data = optQp(Ki67b, n = 2L), 
  contX = 'Marker', R = 100)
summary(mod_b)
}

}
\references{
Selection of optimal quantile protein biomarkers based on cell-level immunohistochemistry data,
Misung Yi, Tingting Zhan , Amy P. Peck, Jeffrey A. Hooke, Albert J. Kovatich, Craig D. Shriver,
Hai Hu, Yunguang Sun, Hallgeir Rui and Inna Chervoneva, under review
}
