% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRI_plot.R
\name{QRI_plot}
\alias{QRI_plot}
\title{Quantile Regression Index plot}
\usage{
QRI_plot(x, y, xlab, ylab, DXcontrol, data)
}
\arguments{
\item{x}{the x coordinate for the QRI plot}

\item{y}{the y coordinate for the QRI plot}

\item{xlab}{the label for the x coordinate}

\item{ylab}{the label for the y coordinate}

\item{DXcontrol}{the expected aging trajectory. It should only be calculated from the controls(i.e. DXcontrol='control==0').
If DXcontrol=NULL, the expected aging trajectory will be calculated from the full data.}

\item{data}{a data frame contains the predictor(x coordinate), response(y coordinate) and control(DXcontrol) in the quantile regression model.}
}
\value{
This function returns a plot for individual measurements.
}
\description{
The QRI_plot() is used to plot Quantile Regression Index (QRI) and generate the normative curves for individual's regional brain imaging metrics.
}
\details{
The QRI score can be used as an alternative to BrainAge to assess accelerated brain aging by determining an individuals' placement
on the expected aging trajectory.A study by Ryan et al (2020) demonstrated that QRI and BrainAge share up to 80\% of the variance in
both patients and controls. The typical function usage involves calling the QRI function with the following parameters (age, sex) on
a list of tissue-specific neuroimaging traits such as regional white matter fractional anisotropy, regional gray matter cortical
thickness, or gray matter subcortical volumes. Quantile regression is performed using the controls (DXcontrol='control==0') to generate
the normative curves for the 5th, 50th, and 95th percentiles. Then each patient (DXcontrol='control==1') and control’s individual
(DXcontrol='control==0') data is compared to the expected aging trajectory. Each regional measure is assigned a score based upon its
location: values > 95\% of the expected age data are assigned a value of “-1”; values < 5\% receive a value of “1”; all others are
assigned “0”. The function then averages across the regional data to generate a tissue-specific QRI score (i.e. white matter QRI).
}
\note{
The QRI_plot() function is developed at the Maryland Psychiatric Research Center, Department of Psychiatry,
University of Maryland School of Medicine. This project is supported by NIH R01 EB015611 grant. Please cite our funding if
you use this software.

Meghann C. Ryan, L. Elliot Hong, Kathryn S. Hatch, Shuo Chen, Krystl Haerian, Jingtao Wang, Eric L. Goldwaser, Xiaoming Du,
Bhim M. Adhikari, Heather Bruce, Stephanie Hare, Mark D. Kvarta, Neda Jahanshad, Thomas E. Nichols, Paul M. Thompson,
Peter Kochunov. The Additive Impact of Metabolic Disorders and Psychiatric Illnesses on Accelerated Brain Aging. In Review
}
\examples{
QRIplot <- QRI_plot(x='Age',y='Ventricle', xlab='Age', ylab='Ventricle', DXcontrol='Control==0',
data=QRIpkg::subcortical)
}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2016.

Roger Koenker (2020). quantreg: Quantile
Regression. R package version 5.61.
https://CRAN.R-project.org/package=quantreg

R Core Team (2020). R: A language and environment for statistical computing. R
Foundation for Statistical Computing, Vienna, Austria. URL
https://www.R-project.org/.
}
