% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_trial_data}
\alias{get_trial_data}
\title{Get the Observations Data of the Current Active Trial}
\usage{
get_trial_data()
}
\value{
A data frame containing the combined observations data from all studies in the active trial.
}
\description{
Retrieves the combined observations data (including all studies) for the current 
active trial, as configured in the internal state object using the \code{\link{set_trial}} function. 
This function iterates over all studies within the active trial and aggregates 
their observation data.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  set_trial("IDYT39")
  MET <- get_trial_data()
  head(MET)
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
