% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_studies}
\alias{list_studies}
\title{Get the list of studies in the current active trial}
\usage{
list_studies()
}
\value{
a list of study and location names
}
\description{
This function will retrieve the studies list from the current active trial 
as configured in the internal state object using `set_trial()` function.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")

# list all environments/locations information in the selected study/trial
list_studies()
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
