% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PySet.R
\name{pySet}
\alias{pySet}
\title{assigns R objects to Python}
\usage{
pySet(key, value, namespace = "__main__", useSetPoly = TRUE,
  useNumpy = pyOptions("useNumpy"), usePandas = pyOptions("usePandas"))
}
\arguments{
\item{key}{a string specifying the name of the Python object.}

\item{value}{a R object which is assigned to Python.}

\item{namespace}{a string specifying where the key should be located.
If the namespace is set to "__main__" the key will be
set to the global namespace. But it is also possible to
set attributes of objects e.g. the attribute name of
the object 'os'.}

\item{useSetPoly}{an optional logical, giving if pySetPoly should be used
to transform R objects into Python objects. For example if
useSetPoly is TRUE unnamed vectors are transformed to
Python objects of type PrVector else to lists.}

\item{useNumpy}{an optional logical, default is FALSE, to control if numpy
should be used for the type conversion of matrices.}

\item{usePandas}{an optional logical, default is FALSE, to control if pandas
should be used for the type conversion of data frames.}
}
\description{
The function pySet allows to assign R objects to the Python
             namespace, the conversion from R to Python is done automatically.
}
\details{
More information about the type conversion can be found in the README
         file or at \url{http://pythoninr.bitbucket.org/}.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
pySet("x", 3)
pySet("M", diag(1,3))
pyImport("os")
pySet("name", "Hello os!", namespace="os")
## In some situations it can be beneficial to convert R lists or vectors
## to Python tuple instead of lists. One way to accomplish this is to change
## the class of the vector to "tuple".
y <- c(1, 2, 3)
class(y) <- "tuple"
pySet("y", y)
## pySet can also be used to change values of objects or dictionaries.
asTuple <- function(x) {
 class(x) <- "tuple"
 return(x)
}
pyExec("d = dict()")
pySet("myTuple", asTuple(1:10), namespace="d")
pySet("myList", as.list(1:5), namespace="d")
}

