% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm-Carter2019.R
\name{dgm.Carter2019}
\alias{dgm.Carter2019}
\title{Carter et al. (2019) Data-Generating Mechanism}
\usage{
\method{dgm}{Carter2019}(dgm_name, settings)
}
\arguments{
\item{dgm_name}{DGM name (automatically passed)}

\item{settings}{List containing \describe{
\item{mean_effect}{Mean effect}
\item{effect_heterogeneity}{Mean effect heterogeneity}
\item{bias}{Degree of publication bias with one of following levels:
\code{"none"}, \code{"medium"}, \code{"high"}.}
\item{QRP}{Degree of questionable research practices with one of following
levels: \code{"none"}, \code{"medium"}, \code{"high"}.}
\item{n_studies}{Number of effect size estimates}
}}
}
\value{
Data frame with \describe{
\item{yi}{effect size}
\item{sei}{standard error}
\item{ni}{sample size}
\item{es_type}{effect size type}
}
}
\description{
This data-generating mechanism simulates primary studies estimating treatment
effects using Cohen's d. The observed effect size is modeled as a fixed mean
plus random heterogeneity across studies, with sample sizes varying to
generate differences in standard errors. The simulation introduces
publication bias via a selection algorithm where the probability of
publication depends nonlinearly on the sign and p-value of the effect,
with regimes for no, medium, and strong publication bias. It also
incorporates questionable research practices (QRPs) such as optional
outlier removal, selection between dependent variables, use of moderators,
and optional stopping.

The description and code is based on
\insertCite{hong2021using;textual}{PublicationBiasBenchmark}.
The data-generating mechanism was introduced in
\insertCite{carter2019correcting;textual}{PublicationBiasBenchmark}.
}
\details{
This simulation environment is based on the framework described by
Carter, Schönbrodt, Gervais, and Hilgard (2019). In this setup,
primary studies estimate the effect of a treatment using Cohen's d as the
effect size metric. The observed difference between treatment and control
groups is modeled as the sum of a fixed effect (alpha1) and a random component,
which introduces effect heterogeneity across studies. The degree of
heterogeneity is controlled by the parameter sigma2_h. Variability in the
standard errors of d is generated by simulating primary studies with
different sample sizes.

The simulation incorporates two main types of distortions in the research
environment. First, a publication selection algorithm is used, where the
probability of a study being "published" depends nonlinearly on both the
sign of the estimated effect and its p-value. Three publication selection
regimes are modeled: "No Publication Bias," "Medium Publication Bias,"
and "Strong Publication Bias," each defined by different parameters in
the selection algorithm. Second, the simulation includes four types of
questionable research practices (QRPs): (a) optional removal of outliers,
(b) optional selection between two dependent variables, (c) optional use of
moderators, and (d) optional stopping.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=dgm]{dgm()}}, \code{\link[=validate_dgm_setting]{validate_dgm_setting()}}
}
