% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.reader.R
\name{sql.reader}
\alias{sql.reader}
\title{Read a database described in a .sql file.}
\usage{
sql.reader(data.file, filename, variable.name)
}
\arguments{
\item{data.file}{The name of the data file to be read.}

\item{filename}{The path to the data set to be loaded.}

\item{variable.name}{The name to be assigned to in the global environment.}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
This function will load data from a SQL database based on configuration
information found in the specified .sql file. The .sql file must specify
a database to be accessed. All tables from the database, one specific tables
or one specific query against any set of tables may be executed to generate
a data set.
}
\details{
queries can support string interpolation to execute code snippets using mustache syntax (http://mustache.github.io). This is used
to create queries that depend on data from other sources. Code delimited is \{\{...\}\}

Example: query: SELECT * FROM my_table WHERE id IN (\{\{ids\}\}).
Here ids is a vector previously loaded into the Global Environment through ProjectTemplate

Examples of the DCF format and settings used in a .sql file are shown
below:

Example 1
type: mysql
user: sample_user
password: sample_password
host: localhost
dbname: sample_database
table: sample_table

Example 2
type: mysql
user: sample_user
password: sample_password
host: localhost
port: 3306
socket: /Applications/MAMP/tmp/mysql/mysql.sock
dbname: sample_database
table: sample_table

Example 3
type: sqlite
dbname: /path/to/sample_database
table: sample_table

Example 4
type: sqlite
dbname: /path/to/sample_database
query: SELECT * FROM users WHERE user_active == 1

Example 5
type: sqlite
dbname: /path/to/sample_database
table: *

Example 6
type: postgres
user: sample_user
password: sample_password
host: localhost
dbname: sample_database
table: sample_table

Example 7
type: odbc
dsn: sample_dsn
user: sample_user
password: sample_password
dbname: sample_database
query: SELECT * FROM sample_table

Example 8
type: oracle
user: sample_user
password: sample_password
dbname: sample_database
table: sample_table

Example 9
type: jdbc
class: oracle.jdbc.OracleDriver
classpath: /path/to/ojdbc5.jar (or set in CLASSPATH)
user: scott
password: tiger
url: jdbc:oracle:thin:@myhost:1521:orcl
query: select * from emp

Example 10
type: heroku
classpath: /path/to/jdbc4.jar (or set in CLASSPATH)
user: scott
password: tiger
host: heroku.postgres.url
port: 1234
dbname: herokudb
query: select * from emp

Example 11
In this example RSQLite::initExtension() is automatically called on the established connection.

Liam Healy has written extension-functions.c, which is available on http://www.sqlite.org/contrib.
It provides mathematical and string extension functions for SQL queries using the loadable extensions mechanism.

type: sqlite
dbname: /path/to/sample_database
plugin: extension
query: SELECT *,STDEV(value1) FROM example_table
}
\examples{
library('ProjectTemplate')

\dontrun{sql.reader('example.sql', 'data/example.sql', 'example')}

}
