% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covls.R
\name{names.procmod_varls}
\alias{names.procmod_varls}
\title{The Names of the elements of a Variance / Covariance Matrix.}
\usage{
\method{names}{procmod_varls}(x)
}
\arguments{
\item{x}{a \code{procmod_varls} object}
}
\description{
Returns the names of the elements associated to a \code{procmod_varls}
object.
}
\examples{
# Build Three matrices of 3 rows.
A <- simulate_matrix(10,3)
B <- simulate_matrix(10,5)
C <- simulate_correlation(B,10,r2=0.6)

# Computes the variance covariance matrix
data <- procmod_frame(A = A, B = B, C = C)
v <- varls(data, nrand = 1000)

names(v)

}
\seealso{
\code{\link[ProcMod]{varls}}
}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
