% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02PTCell.r
\name{sampleNumber}
\alias{sampleNumber}
\alias{sampleNumber,PTCell-method}
\alias{sampleNumber<-}
\alias{sampleNumber<-,PTCell,numeric-method}
\title{Extract or replace a sample number}
\usage{
\S4method{sampleNumber}{PTCell}(x)

\S4method{sampleNumber}{PTCell,numeric}(x) <- value
}
\arguments{
\item{x}{A \code{PTCell} object from which the \code{\link{PTSample}} index
number needs to be be extracted or replaced.}

\item{value}{A \code{numeric} replacement value for the index. Valid indices
range from 1 up to 31. A value of 0 can also be assigned, but will not play
any sample.}
}
\value{
For \code{sampleNumber}, a \code{numeric} value representing the
sample index number of object \code{x} is returned.

For \code{sampleNumber<-}, an copy of object \code{x} is returned in which
the sample index number is replaced with \code{value}.
}
\description{
Extract or replace a \code{\link{PTSample}} index number from a
\code{\link{PTCell}} object.
}
\details{
The \code{\link{PTSample}} index number in a \code{\link{PTCell}} object,
indicates which sample from a \code{\link{PTModule}} object needs to be played.
This method can be used to extract or replace this index from a
\code{\link{PTCell}} object.
}
\examples{
data("mod.intro")

## get the sample index number of PTCell at pattern #3,
## track #2, row #1 from mod.intro (which is 2):

sampleNumber(PTCell(mod.intro, 1, 2, 3))

## replace the sample index number of PTCell at pattern #3,
## track #2, row #1 from mod.intro with 1:

sampleNumber(PTCell(mod.intro, 1, 2, 3)) <- 1
}
\seealso{
Other cell.operations: 
\code{\link{PTCell-class}},
\code{\link{PTCell-method}},
\code{\link{effect}()},
\code{\link{note}()}
}
\author{
Pepijn de Vries
}
\concept{cell.operations}
