% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{read.module}
\alias{read.module}
\alias{read.module,ANY-method}
\alias{read.module,character-method}
\title{Read a ProTracker module file}
\usage{
\S4method{read.module}{character}(file, ignore.validity = F)

\S4method{read.module}{ANY}(file, ignore.validity = F)
}
\arguments{
\item{file}{either a filename or a file connection, that
allows reading binary data (see e.g., \code{\link[base]{file}} or \code{\link[base]{url}}).}

\item{ignore.validity}{A \code{logical} value indicating whether the
validity of the \code{PTModule} should be ignored. When set to
\code{FALSE} (default), the validity of the read object is checked; an
error is thrown when the object is not valid. When this argument is set to
\code{TRUE}, the validity of the object will not be checked and a potentially
invalid object is returned. As the validity check of \code{PTModule}
objects is very strict, it can be useful to ignore this check. This way
you can try to read a broken module file, try to fix it such that it becomes valid and
save (with \code{\link{write.module}}) it again.}
}
\value{
Returns a \code{PTModule} object read from the provided ProTracker file
}
\description{
Reads a ProTracker module file and coerces it to a \code{\link{PTModule}}
object.
}
\details{
The routine to read ProTracker modules is based on the referenced version
of ProTracker 2.3A. This means that the routine may not be able to
read files produced with later ProTracker versions, or earlier versions with
back-compatibility issues. So far I've successfully tested this method
on all modules I've composed with ProTracker version 2.3A (which I believe
was one of the more popular versions of ProTracker back in the days).

It should also be able to read most of the .mod files in
\href{http://modarchive.org/}{The Mod Archive}.
}
\examples{
\dontrun{

## first create an module file from example data:
data("mod.intro")
write.module(mod.intro, "intro.mod")

## read the module:
mod  <-  read.module("intro.mod")

## or create a connection yourself:
con  <- file("intro.mod", "rb")

## note that you can also read from URL connections!
mod2 <- read.module(con)

## don't forget to close the file:
close(con)
}
}
\author{
Pepijn de Vries
}
\references{
\url{http://wiki.multimedia.cx/index.php?title=Protracker_Module}

\url{http://coppershade.org/articles/More!/Topics/Protracker_File_Format/}
}
\seealso{
Other io.operations: \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}

Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}
}

