% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lobbyist_bundlers.R
\name{get_lobbyist_bundlers}
\alias{get_lobbyist_bundlers}
\title{Get Lobbyist Bundlers for a Specific Committee}
\usage{
get_lobbyist_bundlers(cycle = 2018, FEC_ID, page = 1, myAPI_Key)
}
\arguments{
\item{cycle}{The election cycle}

\item{FEC_ID}{The FEC-assigned 9-character ID of a committee. To find a committee’s official FEC ID, use a committee search request or the FEC web site.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the most recent lobbyist bundlers reported by a specific committee.
}
\description{
Committees must report registered lobbyists who act as “bundlers”, collecting donations for the committee from multiple contributors. HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/committees/{fec-id}/lobbyist_bundlers
}
\examples{
\dontrun{
get_lobbyist_bundlers(2016, 'C00579458')
}
}
