% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_committee_filings.R
\name{get_committee_filings}
\alias{get_committee_filings}
\title{Get Committee Filings}
\usage{
get_committee_filings(FEC_ID, cycle = 2018, page = 1, myAPI_Key)
}
\arguments{
\item{FEC_ID}{The FEC-assigned 9-character ID of a committee.}

\item{cycle}{The election cycle}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent FEC filings from the specified committee. Electronic filings are available back to 2001. Paper filings by Senate candidate committees and senatorial party committees go back to 1999.
}
\description{
HTTP Request GET https://api.propublica.org/campaign-finance/v1/{cycle}/committees/{fec-id}/filings
}
\examples{
\donttest{
get_committee_filings('C00553560', 2016)
}
}
