% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_comparing_indices.R
\name{compare_distances}
\alias{compare_distances}
\title{Calculating distances between price indices}
\usage{
compare_distances(
  data = data.frame(),
  measure = "MAD",
  pp = TRUE,
  first = TRUE,
  prec = 3
)
}
\arguments{
\item{data}{A data frame containg values of indices which are to be compared}

\item{measure}{A parameter specifying what measure should be used to compare the indexes. Possible parameter values are: "MAD" (Mean Absolute Distance) or "RMSD" (Root Mean Square Distance).}

\item{pp}{Logical parameter indicating whether the results are to be presented in percentage points (then \code{pp} = TRUE).}

\item{first}{A logical parameter that determines whether the first row of the data frame is to be taken into account when calculating the distance between the indices (then \code{first} = TRUE). Usually, the first row concerns the index values for the base period - all indexes are then set to one.}

\item{prec}{Parameter that determines how many decimal places are to be used in the presentation of results.}
}
\value{
The function calculates average distances between price indices and it returns a data frame with these values for each pair of price indices.
}
\description{
The function calculates distances between price indices
}
\examples{
#Creating a data frame with unweighted bilateral index values
\donttest{df<-price_indices(milk, 
formula=c("jevons","dutot","carli"), 
start="2018-12", end="2019-12",interval=TRUE)}
#Calculating average distances between indices (in p.p)
\donttest{compare_distances(df)}
}
