% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{QU}
\alias{QU}
\title{Calculating the quality adjusted unit value index (QU index)}
\usage{
QU(data, start, end, v)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{v}{The data frame with adjustment factors for at least all matched prodIDs. It must contain two columns: \code{prodID} (as numeric or character) with unique product IDs and \code{values} (as positive numeric) with corresponding adjustment factors.}
}
\value{
This function returns a value of the quality adjusted unit value index (QU index) for a given set of adjustment factors (adjusted factors must be available for all matched prodIDs).
}
\description{
This function returns a value of the quality adjusted unit value index (QU index) for a given set of adjustment factors.
}
\examples{
## Creating a data frame with artificial adjustment factors 
## (random numbers from uniform distribution U[1,2])
\donttest{prodID<-unique(milk$prodID)}
\donttest{values<-stats::runif(length(prodID),1,2)}
\donttest{v<-data.frame(prodID,values)}
## Calculating the QU index for the created data frame 'v'
\donttest{QU(milk, start="2018-12", end="2019-12", v)}
}
\references{
{Chessa, A.G. (2016). \emph{A New Methodology for Processing Scanner Data in the Dutch CPI.} Eurona 1/2016, 49-69.}
}
