% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pqcor}
\alias{pqcor}
\title{Providing a correlation coefficient for price and quantity of sold products}
\usage{
pqcor(data, period, set = c(), figure = FALSE)
}
\arguments{
\item{data}{The user's data frame. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities} (as positive numeric) and \code{prodID} (as numeric or character) with unique product IDs.}

\item{period}{The time period (as character) limited to the year and month, e.g. "2019-03".}

\item{set}{The set of unique product IDs to be used for determining correlation between price and quantity of sold products (see also \code{\link{data_matching}}). If the \code{set} is empty, the function works for all products being available in \code{period}.}

\item{figure}{A logical parameter indicating whether the function returns a figure (TRUE) or a data frame (FALSE) with correlations between price and quantity of sold products.}
}
\value{
The function returns Pearson's correlation coefficient between price and quantity of products with given IDs and sold in \code{period}.
}
\description{
The function returns correlation between price and quantity of sold products with given IDs.
}
\examples{
pqcor(milk, period="2019-03")
\donttest{pqcor(milk, period="2019-03",figure=TRUE)}
}
