% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{adjust.sigma2}
\alias{adjust.sigma2}
\title{Adjustment factor for the variance of the convolution of Gaussian noise}
\usage{
adjust.sigma2(knots.dist, phi, kappa)
}
\arguments{
\item{knots.dist}{a matrix of the distances between the observed coordinates and the spatial knots.}

\item{phi}{scale parameter of the Matern covariance function.}

\item{kappa}{shape parameter of the Matern covariance function.}
}
\value{
A value corresponding to the adjustment factor for \code{sigma2}.
}
\description{
This function computes the multiplicative constant used to adjust the value of \code{sigma2} in the low-rank approximation of a Gaussian process.
}
\details{
Let \eqn{U} denote the \eqn{n} by \eqn{m} matrix of the distances between the \eqn{n} observed coordinates and \eqn{m} pre-defined spatial knots. This function computes the following quantity
\deqn{\frac{1}{n}\sum_{i=1}^n \sum_{j=1}^m K(u_{ij}; \phi, \kappa)^2,}
where \eqn{K(.; \phi, \kappa)} is the Matern kernel (see \code{\link{matern.kernel}}) and \eqn{u_{ij}} is the distance between the \eqn{i}-th sampled location and the \eqn{j}-th spatial knot.
}
\seealso{
\code{\link{matern.kernel}}, \code{\link{pdist}}.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
