% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtesting.R
\name{plot.backtest_result}
\alias{plot.backtest_result}
\title{Plot Backtest Results}
\usage{
\method{plot}{backtest_result}(x, type = "performance", ...)
}
\arguments{
\item{x}{backtest_result object}

\item{type}{Plot type: "performance", "drawdown", "weights", or "all"}

\item{...}{Additional plotting parameters}
}
\value{
NULL (creates plot)
}
\description{
S3 plot method for visualizing backtest performance.
}
\examples{
data("sample_prices_weekly")
mom <- calc_momentum(sample_prices_weekly, lookback = 12)
sel <- filter_top_n(mom, n = 10)
W   <- weight_equally(sel)
res <- run_backtest(sample_prices_weekly, W)
if (interactive()) plot(res, type = "performance")
}
