% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_between}
\alias{filter_between}
\title{Filter Stocks Between Two Values}
\usage{
filter_between(signal_df, lower, upper)
}
\arguments{
\item{signal_df}{Data frame with signal values}

\item{lower}{Lower bound (inclusive)}

\item{upper}{Upper bound (inclusive)}
}
\value{
Binary selection matrix
}
\description{
Selects stocks with signal values between lower and upper bounds.
}
\examples{
data("sample_prices_weekly")
rsi <- calc_rsi(sample_prices_weekly, 14)
# Select stocks with RSI between 30 and 70
neutral_rsi <- filter_between(rsi, 30, 70)
}
