/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.producer;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.openfast.examples.Assert;
import org.openfast.examples.MessageBlockWriterFactory;
import org.openfast.examples.OpenFastExample;
import org.openfast.examples.producer.FastMessageProducer;
import org.openfast.examples.producer.MulticastFastMessageProducer;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.multicast.MulticastServerEndpoint;
import org.openfast.session.tcp.TcpEndpoint;

public class Main
extends OpenFastExample {
    private static Options options = new Options();

    static {
        options.addOption("?", "help", false, "Displays this message");
        options.addOption("r", "protocol", true, "Protocol [tcp|udp] defaults to tcp");
        options.addOption("p", "port", true, "Port to serve data on");
        options.addOption("h", "host", true, "The host name of the server (or group name for multicast)");
        options.addOption("i", "interface", true, "The ip address of the network interface to use");
        options.addOption("e", "error", false, "Show stacktrace information");
        options.addOption("t", "template", true, "Message template definition file");
        options.addOption("x", "xml", true, "The XML data to convert to FAST");
        options.addOption("k", "writeOffset", true, "The number of leading bytes that should be appended as padding when sending each message.");
        options.addOption("z", "variant", true, "Enable exchange-specific behavior.  Valid values: CME");
        options.addOption("d", "reset", false, "Enable reset of the encoder/decoder on every message.");
    }

    public static void main(String[] args) {
        CommandLine cl = Main.parseCommandLine("producer", args, options);
        if (cl.hasOption("help")) {
            Main.displayHelp("producer", options);
        }
        Endpoint endpoint = null;
        boolean showStacktrace = cl.hasOption("error");
        File templatesFile = null;
        File xmlDataFile = null;
        try {
            String ifaddr;
            Assert.assertTrue(cl.hasOption("port"), "The required parameter \"port\" is missing.");
            int port = Main.getInteger(cl, "port");
            String host = cl.hasOption("host") ? cl.getOptionValue("host") : "localhost";
            String string = ifaddr = cl.hasOption("interface") ? cl.getOptionValue("interface") : null;
            if (Main.isMulticast(cl)) {
                endpoint = new MulticastServerEndpoint(port, host, ifaddr);
            }
            if (endpoint == null) {
                endpoint = new TcpEndpoint(host, port);
            }
            templatesFile = Main.getFile(cl, "template");
            xmlDataFile = Main.getFile(cl, "xml");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            Main.displayHelp("consumer", options);
        }
        try {
            int writeOffset = cl.hasOption("writeOffset") ? Main.getInteger(cl, "writeOffset") : 0;
            OpenFastExample.Variant variant = cl.hasOption("variant") ? Main.getVariant(cl) : OpenFastExample.Variant.DEFAULT;
            boolean shouldResetOnEveryMessage = cl.hasOption("reset") || OpenFastExample.Variant.CME == variant;
            MessageBlockWriterFactory msgBlockWriterFactory = new MessageBlockWriterFactory(variant, writeOffset, Main.isMulticast(cl));
            FastMessageProducer producer = Main.isMulticast(cl) ? new MulticastFastMessageProducer(endpoint, templatesFile, msgBlockWriterFactory, shouldResetOnEveryMessage) : new FastMessageProducer(endpoint, templatesFile, msgBlockWriterFactory, shouldResetOnEveryMessage);
            producer.start();
            producer.encode(xmlDataFile);
            producer.stop();
        }
        catch (FastConnectionException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("Unable to connect to endpoint: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("An IO error occurred while consuming messages: " + e.getMessage());
            System.exit(1);
        }
    }
}

