/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.performance;

import java.io.IOException;
import java.io.InputStream;

public class HexadecimalInputStream
extends InputStream {
    private final InputStream in;
    private byte[] buffer = new byte[32];

    public HexadecimalInputStream(InputStream in) {
        this.in = in;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.length < len * 2) {
            this.buffer = new byte[len * 2];
        }
        int byteCount = 0;
        while (byteCount < len) {
            int toRead = (len - byteCount) * 2;
            int numRead = this.in.read(this.buffer, 0, toRead);
            boolean eof = numRead < toRead;
            int index = 0;
            while (index < numRead) {
                if (this.buffer[index] == 13 || this.buffer[index] == 10) {
                    ++index;
                    continue;
                }
                if (index + 1 == numRead) {
                    byte[] temp = new byte[]{this.buffer[index], (byte)this.in.read()};
                    String data = new String(temp);
                    b[off + byteCount] = (byte)Integer.parseInt(data, 16);
                    ++byteCount;
                    break;
                }
                String data = new String(this.buffer, index, 2);
                b[off + byteCount] = (byte)Integer.parseInt(data, 16);
                ++byteCount;
                index += 2;
            }
            if (!eof) continue;
            return byteCount;
        }
        return byteCount;
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

