% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ancestry_barchart.R
\name{Ancestry_barchart}
\alias{Ancestry_barchart}
\title{Plot an ancestry matrix for individuals and(or) populations.}
\usage{
Ancestry_barchart(
  anc.mat,
  pops,
  K,
  plot.type = "all",
  col,
  ind.order = NULL,
  pop.order = NULL
)
}
\arguments{
\item{anc.mat}{Data frame or character string that supplies the input data. If it is a character string, the file should be a csv. The first column should be the names of each sample/population, followed by the estimated contribution of each cluster to that individual/pop.}

\item{pops}{Data frame or character string that supplies the input data. If it is a character string, the file should be a csv. The columns should be named Sample, containing the sample IDs; Population indicating the population assignment of the individual, population and sample names must be the same type (i.e., both numeric or both characters); Long, indicating the longitude of the sample; Lat, indicating the latitude of the sample.}

\item{K}{Numeric.The number of genetic clusters in your data set, please contact the package authors if you need help doing this.}

\item{plot.type}{Character string. Options are all, individual, and population. All is default and recommended, this will plot a barchart for both the individuals and populations.}

\item{col}{Character vector indicating the colors you wish to use for plotting.}

\item{ind.order}{Character vector indicating the order to plot the individuals in the individual ancestry bar chart.}

\item{pop.order}{Chracter vector indicating the order to plot the populations in the population ancesyry bar chart.}
}
\value{
A list containing your plots and the data frames used to generate the plots.
}
\description{
Plot an ancestry matrix for individuals and(or) populations.
}
\examples{
\donttest{
data(Q_dat)
Qmat <- Q_dat[[1]]
rownames(Qmat) <- Qmat[,1]
Loc <- Q_dat[[2]]
Test_all <- Ancestry_barchart(anc.mat = Qmat, pops = Loc, K = 5,
plot.type = 'all',col = c('#d73027', '#fc8d59', '#e0f3f8', '#91bfdb', '#4575b4'))}
}
\author{
Keaka Farleigh
}
