% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_design.R
\name{evaluate_design}
\alias{evaluate_design}
\title{Evaluate a design}
\usage{
evaluate_design(poped.db, ...)
}
\arguments{
\item{poped.db}{A poped database}

\item{...}{Extra parameters passed to \code{\link{calc_ofv_and_fim}} and \code{\link{get_rse}}}
}
\value{
A list of elements evaluating the current design.
}
\description{
This tunction evaluates the design defined in a poped database.
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin example)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=0.01,
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70)

############# END ###################
## Create PopED database
## (warfarin example)
#####################################

evaluate_design(poped.db)


}
\seealso{
Other evaluate_design: \code{\link{evaluate.fim}},
  \code{\link{get_rse}}, \code{\link{model_prediction}},
  \code{\link{plot_efficiency_of_windows}},
  \code{\link{plot_model_prediction}}
}

