% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VGM_expanded_clones.R
\name{VGM_expanded_clones}
\alias{VGM_expanded_clones}
\title{VDJ utility for T/F column for clonal expansion}
\usage{
VGM_expanded_clones(VGM, add.to.VDJ, add.to.GEX, expansion.threshold)
}
\arguments{
\item{VGM}{Output object from the VDJ_GEX_matrix function (VDJ_GEX_matrix.output)}

\item{add.to.VDJ}{Boolean. Whether to add expanded columns to VDJ matrix. Defaults to TRUE}

\item{add.to.GEX}{Boolean. Whether to add expanded columns to GEX matrix. Defaults to TRUE}

\item{expansion.threshold}{Integer. Defaults to 1. Cells in clonotypes above this threshold will be marked as expanded = TRUE.}
}
\value{
An output object from the VDJ_GEX_matrix function with added columns containing TRUE / FALSE values based on clonotype frequency.
}
\description{
Adds discrete columns containing TRUE / FALSE on whether a given cell is part of a expanded or not-expanded clonotype. Threshold frequency can be set.
}
\examples{

#Add info to whole VGM object
VGM <- VGM_expanded_clones(
VGM = Platypus::small_vgm, add.to.VDJ = TRUE, add.to.GEX = TRUE,
expansion.threshold = 1)

}
