% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_call_recon.R
\name{VDJ_call_recon}
\alias{VDJ_call_recon}
\title{Calls the Kaplinsky/RECON tool}
\usage{
VDJ_call_recon(
  VDJ,
  recon.directory,
  sample.id,
  clone.list,
  max.clones,
  size.threshold,
  resample,
  plot.results,
  max.clone.size,
  reticulate,
  output.format,
  operating.system
)
}
\arguments{
\item{VDJ}{VDJ or VDJ.GEX.matrix[[1]] object, as obtained from the VDJ_GEX_matrix function in Platypus.}

\item{recon.directory}{directory containing recon executable. Defaults to {working directory}/Recon}

\item{sample.id}{boolean - if F, clonotypes will be considered at a global level, irrespective of samples.}

\item{clone.list}{list - if empty, RECON will be used to estimate the diversity of all clonotypes, else it will only consider the specified clonotypes.}

\item{max.clones}{integer or 'all' - maximum number of clones ot be considered for the RECON estimation. If 'all', will consider all clonotypes.}

\item{size.threshold}{integer - the size threshold parameter for the RECON tool, as specified by the '-t' parameter.}

\item{resample}{boolean - if T, will also perform and output a resample of the clonotype frequencies/sizes from the inferred parent distribution.}

\item{plot.results}{boolean - if T, will save a pdf of the resampled clonotype frequencies/sizes from the RECON-inferred distribution along the original frequencies.}

\item{max.clone.size}{integer - the maximum size of clones to be considered in the resulting plot (maximum number of elements on the x axis).}

\item{reticulate}{boolean - if T, will create a new environment to install python and run the RECON tool, else, your environment must have a python version compatible with RECON installed.}

\item{output.format}{string - 'vgm' will append the means and weights of the RECON-inferred distribution to the VDJ/VDJ.GEX.matrix[[1]] object, 'recon' will output a new dataframe of these weights, 'plots' will output the ggplot2 objects (if plot.results=T).}

\item{operating.system}{string - operating system on which RECON will be run. 'Windows' for Windows, 'Linux' for Linux, 'Darwin' for MacOS.}
}
\value{
The resulting means and weights of the RECON-inferred distribution as a seprate dataframe or appended to the VDJ, or a plot of resampled clonotype sizes from the inferred distribution vs original sizes/frequencies.
}
\description{
Calls the Kaplinsky/RECON tool on the VDJ/VDJ.GEX.matrix[[1]] object to infer the parent distribution of clonotypes and estimate their diversity. Outputs either a dataframe of the resulting means and weights of the RECON clonotype parent distribution estimation or a plot of the original clonotype distribution along resampled values from the reconstructed parent distribution.
}
\examples{
\dontrun{
VDJ_call_recon(VDJ, recon.directory='./Recon',
max.clones='all', sample.id=T, resample=F,
plot.results=T, output.format='vgm',
reticulate=T, operating.system='Darwin')
}
}
