% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arc.R
\name{Arc}
\alias{Arc}
\title{R6 class representing a circular arc}
\description{
An arc is given by a center, a radius, a starting angle and
an ending angle. They are respectively named \code{center}, \code{radius},
\code{alpha1} and \code{alpha2}.
}
\examples{

## ------------------------------------------------
## Method `Arc$new`
## ------------------------------------------------

arc <- Arc$new(c(1,1), 1, 45, 90)
arc
arc$center
arc$center <- c(0,0)
arc

## ------------------------------------------------
## Method `Arc$print`
## ------------------------------------------------

Arc$new(c(0,0), 2, pi/4, pi/2, FALSE)

## ------------------------------------------------
## Method `Arc$complementaryArc`
## ------------------------------------------------

arc <- Arc$new(c(0,0), 1, 30, 60)
plot(NULL, type = "n", asp = 1, xlim = c(-1,1), ylim = c(-1,1),
     xlab = NA, ylab = NA)
draw(arc, lwd = 3, col = "red")
draw(arc$complementaryArc(), lwd = 3, col = "green")
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{center}}{get or set the center}

\item{\code{radius}}{get or set the radius}

\item{\code{alpha1}}{get or set the starting angle}

\item{\code{alpha2}}{get or set the ending angle}

\item{\code{degrees}}{get or set the \code{degrees} field}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Arc$new()}}
\item \href{#method-print}{\code{Arc$print()}}
\item \href{#method-startingPoint}{\code{Arc$startingPoint()}}
\item \href{#method-endingPoint}{\code{Arc$endingPoint()}}
\item \href{#method-isEqual}{\code{Arc$isEqual()}}
\item \href{#method-complementaryArc}{\code{Arc$complementaryArc()}}
\item \href{#method-path}{\code{Arc$path()}}
\item \href{#method-clone}{\code{Arc$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Arc} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$new(center, radius, alpha1, alpha2, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{center}}{the center}

\item{\code{radius}}{the radius}

\item{\code{alpha1}}{the starting angle}

\item{\code{alpha2}}{the ending angle}

\item{\code{degrees}}{logical, whether \code{alpha1} and \code{alpha2} are
given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Arc} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{arc <- Arc$new(c(1,1), 1, 45, 90)
arc
arc$center
arc$center <- c(0,0)
arc
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{Arc} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Arc$new(c(0,0), 2, pi/4, pi/2, FALSE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-startingPoint"></a>}}
\if{latex}{\out{\hypertarget{method-startingPoint}{}}}
\subsection{Method \code{startingPoint()}}{
Starting point of the reference arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$startingPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-endingPoint"></a>}}
\if{latex}{\out{\hypertarget{method-endingPoint}{}}}
\subsection{Method \code{endingPoint()}}{
Ending point of the reference arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$endingPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isEqual"></a>}}
\if{latex}{\out{\hypertarget{method-isEqual}{}}}
\subsection{Method \code{isEqual()}}{
Check whether the reference arc equals another arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$isEqual(arc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arc}}{an \code{Arc} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-complementaryArc"></a>}}
\if{latex}{\out{\hypertarget{method-complementaryArc}{}}}
\subsection{Method \code{complementaryArc()}}{
Complementary arc of the reference arc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$complementaryArc()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{arc <- Arc$new(c(0,0), 1, 30, 60)
plot(NULL, type = "n", asp = 1, xlim = c(-1,1), ylim = c(-1,1),
     xlab = NA, ylab = NA)
draw(arc, lwd = 3, col = "red")
draw(arc$complementaryArc(), lwd = 3, col = "green")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path"></a>}}
\if{latex}{\out{\hypertarget{method-path}{}}}
\subsection{Method \code{path()}}{
The reference arc as a path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$path(npoints = 100L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{npoints}}{number of points of the path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with two columns \code{x} and \code{y} of length
\code{npoints}. See "Filling the lapping area of two circles" in the
vignette for an example.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arc$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
