% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Intersections.R
\name{intersectionEllipseLine}
\alias{intersectionEllipseLine}
\title{Intersection of an ellipse and a line}
\usage{
intersectionEllipseLine(ell, line, strict = FALSE)
}
\arguments{
\item{ell}{an \code{Ellipse} object or a \code{Circle} object}

\item{line}{a \code{Line} object}

\item{strict}{logical, whether to take into account \code{line$extendA} and
\code{line$extendB} if they are not both \code{TRUE}}
}
\value{
\code{NULL} if there is no intersection;
a point if the infinite line is tangent to the ellipse, or \code{NULL}
if \code{strict=TRUE} and the point is not on the line (segment or half-line);
a list of two points if the ellipse and the infinite line meet at
two points, when \code{strict=FALSE}; if \code{strict=TRUE} and the line is
a segment or a half-line, this can return \code{NULL} or a single point.
}
\description{
Return the intersection of an ellipse and a line.
}
\examples{
ell <- Ellipse$new(c(1,1), 5, 1, 30)
line <- Line$new(c(2,-2), c(0,4))
( Is <- intersectionEllipseLine(ell, line) )
ell$includes(Is$I1); ell$includes(Is$I2)
}
