% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{parsimonyNumber}
\alias{parsimonyNumber}
\title{Number of equivalent parsimonious allocations.}
\usage{
parsimonyNumber(phylo, clusters = rep(1, length(phylo$tip.label)))
}
\arguments{
\item{phylo}{phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{clusters}{the vector of the clusters of the tips. Default to all the tips
in one single cluster.}
}
\value{
an object of S3 class "\code{parsimonyNumber}" with:
\describe{
 \item{nbrReconstructions}{a (ntaxa + Nnode) x (nclus)
 matrix of locally parsimonious solutions starting from a cluster k at a
 given node}
 \item{costReconstructions}{an object of class "\code{parsimonyCost}",
 result of function \code{\link{parsimonyCost}}.}
}
}
\description{
\code{parsimonyNumber} aims at finding the number of equivalent allocations of
the shifts on the tree, i.e allocations that are parsimonious and compatible
with a given clustering of the tips.
}
\details{
This function does a recursion up the tree.
The function \code{\link{extract.parsimonyNumber}} gives the result sought for
any subtree.
The matrix of costs of the states (number of shifts) is also required, it is
computed by function \code{\link{parsimonyCost}}.
}
\examples{
tree <- read.tree(text="(((0,1),2),2);")
plot(tree); nodelabels()
clusters <- c(0, 1, 2, 2)
n_sols <- parsimonyNumber(tree, clusters)
n_sols

## Extract the number of parsimonious solutions at the root
extract(n_sols)

## Extract the cost of the solutions from the root
extract(n_sols, what = "cost")
extract(parsimonyCost(tree, clusters)) # same, more efficient

## Extract for the sub-tree below node 7
extract(n_sols, 7) # Result: 2 (the ancestral state is either "0" or "1"). 

}
\seealso{
\code{\link{extract.parsimonyNumber}}, \code{\link{parsimonyCost}}, 
\code{\link{enumerate_parsimony}}, \code{\link{partitionsNumber}},
\code{\link{equivalent_shifts}}
}
