% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelistDiagnostics.R
\name{codelistDiagnostics}
\alias{codelistDiagnostics}
\title{Run codelist-level diagnostics}
\usage{
codelistDiagnostics(cohort)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference. The cohort_codelist
attribute must be populated. The cdm reference must contain achilles
tables as these will be used for deriving concept counts.}
}
\value{
A summarised result
}
\description{
`codelistDiagnostics()` runs phenotypeR diagnostics on the cohort_codelist
attribute on the cohort. Thus codelist attribute of the cohort must be
populated. If it is missing then it could be populated using
`addCodelistAttribute()` function.

Furthermore `codelistDiagnostics()` requires achilles tables to be present in
the cdm so that concept counts could be derived.
}
\examples{
\donttest{
library(CohortConstructor)
library(PhenotypeR)

cdm <- mockPhenotypeR()

cdm$arthropathies <- conceptCohort(cdm,
                                   conceptSet = list("arthropathies" = c(40475132)),
                                   name = "arthropathies")

result <- codelistDiagnostics(cdm$arthropathies)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
