% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixData.R
\name{MatrixDataCheck}
\alias{MatrixDataCheck}
\alias{MatrixDataCheck.default}
\alias{MatrixDataCheck.matrixData}
\alias{MatrixDataCheck.list}
\alias{MatrixDataCheck.ExpressionSet}
\title{MatrixDataCheck: a function to check the validity of an object as a perseus data frame}
\usage{
MatrixDataCheck(object, ...)

\method{MatrixDataCheck}{default}(object = NULL, main, annotationRows,
  annotationCols, descriptions, imputeData, qualityData, all_colnames, ...)

\method{MatrixDataCheck}{matrixData}(object, ...)

\method{MatrixDataCheck}{list}(object, ...)

\method{MatrixDataCheck}{ExpressionSet}(object, ...)
}
\arguments{
\item{object}{object to check consistency with perseus data frames}

\item{...}{additional arguments passed to the respective method}

\item{main}{Main Data frame}

\item{annotationRows}{Rows containing annotation information}

\item{annotationCols}{Collumns containing annotation information}

\item{descriptions}{Descriptions of all the columns}

\item{imputeData}{Is imputed or not}

\item{qualityData}{quality number}

\item{all_colnames}{The colnames to be used}
}
\value{
a logical indicating the validity of the object
(or series of objects) as a perseus DF or the string of errors

\code{NULL}

\code{NULL}

\code{NULL}
}
\description{
Check perseus compatibility of an object
}
\examples{

require(PerseusR)

mat <- matrixData(
    main=data.frame(a=1:3, b=6:8),
    annotCols=data.frame(c=c('a','b','c')),
    annotRows=data.frame(x=factor(c('1','1'))))

MatrixDataCheck(mat)


}
