% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummarised.R
\name{plotCohortIntersect}
\alias{plotCohortIntersect}
\title{Plot summariseCohortIntersect output.}
\usage{
plotCohortIntersect(
  data,
  xAxis = "variable_name",
  yAxis = "estimate_value",
  plotStyle = "barplot",
  facetVars = NULL,
  colorVars = NULL,
  facetOrder = NULL,
  colorNames = NULL,
  vertical_x = FALSE,
  options = list()
)
}
\arguments{
\item{data}{output of summariseCohortIntersect}

\item{xAxis}{what to plot on x axis, default as variable_name column. Has to be a column in data.}

\item{yAxis}{what to plot on y axis, default as estimate_value column. Has to be a column in data. One of the xAxis or yAxis has to be estimate_value.}

\item{plotStyle}{Now allows boxplot or barplot only.}

\item{facetVars}{column in data to facet by.}

\item{colorVars}{column in data to color by.}

\item{facetOrder}{order of facet, make sure multiple facets are separated by period and in the order provided in facetVars.}

\item{colorNames}{A vector or pre-selected color.}

\item{vertical_x}{whether to display x axis string vertically.}

\item{options}{Other plot options in a list.}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- mockPatientProfiles()
results <- summariseCohortIntersect(
  cohort = cdm$cohort1,
  cohortIntersect = list(
    "Medications in the prior year" = list(
      targetCohortTable = "cohort2", value = "flag", window = c(-365, -1)
    )
  )
)
graph <- plotCohortIntersect(results)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
