% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortIntersect.R
\name{addCohortIntersectDays}
\alias{addCohortIntersectDays}
\title{It creates columns to indicate the number of days between the current table
and a target cohort}
\usage{
addCohortIntersectDays(
  x,
  cdm = attr(x, "cdm_reference"),
  targetCohortTable,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetDate = "cohort_start_date",
  order = "first",
  window = c(0, Inf),
  nameStyle = "{cohort_name}_{window_name}",
  tablePrefix = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm}

\item{cdm}{Object that contains a cdm reference. Use CDMConnector to obtain a
cdm reference.}

\item{targetCohortTable}{Cohort table to}

\item{targetCohortId}{Cohort IDs of interest from the other cohort table. If
NULL, all cohorts will be used with a days variable added for each
cohort of interest}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x}

\item{targetDate}{Date of interest in the other cohort table. Either
cohort_start_date or cohort_end_date}

\item{order}{date to use if there are multiple records for an
individual during the window of interest. Either first or last.}

\item{window}{Window of time to identify records relative to the indexDate.
Records outside of this time period will be ignored.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters}

\item{tablePrefix}{The stem for the permanent tables that will
be created. If NULL, temporary tables will be used throughout.}
}
\value{
x along with additional columns for each cohort of interest.
}
\description{
It creates columns to indicate the number of days between the current table
and a target cohort
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cohort1 <- dplyr::tibble(
  cohort_definition_id = c(1, 1, 1, 1, 1),
  subject_id = c(1, 1, 1, 2, 2),
  cohort_start_date = as.Date(
    c(
      "2020-01-01",
      "2020-01-15",
      "2020-01-20",
      "2020-01-01",
      "2020-02-01"
    )
  ),
  cohort_end_date = as.Date(
    c(
      "2020-01-01",
      "2020-01-15",
      "2020-01-20",
      "2020-01-01",
      "2020-02-01"
    )
  )
)

cohort2 <- dplyr::tibble(
  cohort_definition_id = c(1, 1, 1, 1, 1, 1, 1),
  subject_id = c(1, 1, 1, 2, 2, 2, 1),
  cohort_start_date = as.Date(
    c(
      "2020-01-15",
      "2020-01-25",
      "2020-01-26",
      "2020-01-29",
      "2020-03-15",
      "2020-01-24",
      "2020-02-16"
    )
  ),
  cohort_end_date = as.Date(
    c(
      "2020-01-15",
      "2020-01-25",
      "2020-01-26",
      "2020-01-29",
      "2020-03-15",
      "2020-01-24",
      "2020-02-16"
    )
  ),
)

cdm <- mockPatientProfiles(cohort1 = cohort1, cohort2 = cohort2)

result <- cdm$cohort1 \%>\%
  addCohortIntersectDays(
    targetCohortTable = "cohort2"
  ) \%>\%
  dplyr::collect()
}

}
