% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCharacteristics.R
\name{summariseCharacteristics}
\alias{summariseCharacteristics}
\title{This function is used to summarise the dose and/or indication over multiple
cohorts.}
\usage{
summariseCharacteristics(
  cohort,
  cdm,
  strata = list(),
  ageGroup = NULL,
  windowVisitOcurrence = NULL,
  covariates = list(),
  minCellCount = 5
)
}
\arguments{
\item{cohort}{A cohort in the cdm}

\item{cdm}{A cdm_reference created by CDMConnector}

\item{strata}{Stratification list}

\item{ageGroup}{A list of age groups.}

\item{windowVisitOcurrence}{Window to count visit occurrences.}

\item{covariates}{Named list of windows to check covariates. The name must
point to a cohortTableName in the cdm.}

\item{minCellCount}{minimum counts due to obscure}
}
\value{
A summary of the characteristics of the individuals
}
\description{
This function is used to summarise the dose and/or indication over multiple
cohorts.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

summariseCharacteristics(
  cdm$cohort1,
  cdm,
  ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150)),
  windowVisitOcurrence = c(-180, 0)
)
}
}
