% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovariateSummary.R
\name{covariateSummary}
\alias{covariateSummary}
\title{covariateSummary}
\usage{
covariateSummary(
  covariateData,
  cohort,
  labels = NULL,
  strata = NULL,
  variableImportance = NULL,
  featureEngineering = NULL
)
}
\arguments{
\item{covariateData}{The covariateData part of the plpData that is
extracted using \code{getPlpData}}

\item{cohort}{The patient cohort to calculate the summary}

\item{labels}{A data.frame with the columns rowId and outcomeCount}

\item{strata}{A data.frame containing the columns rowId, strataName}

\item{variableImportance}{A data.frame with the columns covariateId and
value (the variable importance value)}

\item{featureEngineering}{(currently not used )
A function or list of functions specifying any feature engineering
to create covariates before summarising}
}
\value{
A data.frame containing: CovariateCount, CovariateMean and CovariateStDev
for any specified stratification
}
\description{
Summarises the covariateData to calculate the mean and standard deviation per covariate
if the labels are given it also stratifies this by class label and if the trainRowIds and testRowIds
specifying the patients in the train/test sets respectively are input, these values are also stratified
by train and test set
}
\details{
The function calculates various metrics to measure the performance of the model
}
\examples{
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=100)
covariateSummary <- covariateSummary(plpData$covariateData, plpData$cohorts)
head(covariateSummary)
}
