% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectiveModelMethods.R
\name{Layer_Var.PPP_Model}
\alias{Layer_Var.PPP_Model}
\title{Variance of a Reinsurance Layer}
\usage{
\method{Layer_Var}{PPP_Model}(CollectiveModel, Cover = Inf, AttachmentPoint = 0)
}
\arguments{
\item{CollectiveModel}{PPP_Model object.}

\item{Cover}{Numeric. Cover of the reinsurance layer. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint}{Numeric. Attachment point of the reinsurance layer.}
}
\value{
The variance of the loss in the layer \code{Cover} xs \code{AttachmentPoint} for the given \code{CollectiveModel}
}
\description{
Calculates the variance of the loss in a reinsurance layer for a PPP_model
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(Example1_AP, Example1_EL)
PPPM
Example1_Cov <- c(diff(Example1_AP), Inf)
Layer_Var(PPPM, Example1_Cov, Example1_AP)

}
