% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{PiecewisePareto_Match_Layer_Losses}
\alias{PiecewisePareto_Match_Layer_Losses}
\title{Match a Tower of Expected Layers Losses}
\usage{
PiecewisePareto_Match_Layer_Losses(
  Attachment_Points,
  Expected_Layer_Losses,
  Unlimited_Layers = FALSE,
  Frequencies = NULL,
  FQ_at_lowest_AttPt = NULL,
  FQ_at_highest_AttPt = NULL,
  TotalLoss_Frequencies = NULL,
  minimize_ratios = TRUE,
  Use_unlimited_Layer_for_FQ = TRUE,
  truncation = NULL,
  tolerance = 1e-10,
  alpha_max = 100,
  merge_tolerance = 1e-06,
  RoL_tolerance = 1e-06
)
}
\arguments{
\item{Attachment_Points}{Numeric vector. Vector containing the attachment points of consecutive layers in increasing order}

\item{Expected_Layer_Losses}{Numeric vector. Vector containing the expected losses of layers xs the attachment points.}

\item{Unlimited_Layers}{Logical. If \code{TRUE}, then \code{Expected_Layer_Losses[i]} contains the expected loss of \code{Inf} xs \code{Attachment_Points[i]}. If \code{FALSE} then \code{Expected_Layer_Losses[i]} contains the expected loss of the layer \code{Attachment_Points[i+1]} xs \code{Attachment_Points[i]}}

\item{Frequencies}{Numeric vector. Expected frequencies excess the attachment points. If \code{NULL} then the function calculates frequencies.}

\item{FQ_at_lowest_AttPt}{Numerical. Expected frequency excess \code{Attachment_Points[1]}}

\item{FQ_at_highest_AttPt}{Numerical. Expected frequency excess \code{Attachment_Points[k]}}

\item{TotalLoss_Frequencies}{Numeric vector. \code{TotalLoss_Frequencies[i]} is the frequency of total losses to layer \code{i} (i.e. \code{Attachment_Points[i+1] - Attachment_Points[i]} xs \code{Attachment_Points[i]}).    \code{TotalLoss_Frequencies[i]} is the frequency for losses larger than or equal to \code{Attachment_Points[i+1]}, whereas \code{Frequencies[i]} is the frequency of losses larger than \code{Attachment_Points[i]}.    \code{TotalLoss_Frequencies[i] > Frequencies[i+1]} means that there is a point mass of the severity at \code{Attachment_Points[i+1]}.}

\item{minimize_ratios}{Logical. If \code{TRUE} then ratios between alphas are minimized.}

\item{Use_unlimited_Layer_for_FQ}{Logical. Only relevant if no frequency is provided for the highest attachment point by the user. If \code{TRUE} then the frequency is calculated using the Pareto alpha between the last two layers.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > max(Attachment_Points)}, then the last Pareto piece is truncated at \code{truncation} (\code{truncation_type = "lp"}).}

\item{tolerance}{Numeric. Numerical tolerance.}

\item{alpha_max}{Numerical. Maximum alpha to be used for the matching.}

\item{merge_tolerance}{Numerical. Consecutive Pareto pieces are merged if the alphas deviate by less than merge_tolerance.}

\item{RoL_tolerance}{Numerical. Consecutive layers are merged if RoL decreases less than factor \code{1 - RoL_tolerance}.}
}
\value{
A list containing the following objects: \itemize{
\item \code{t} Numeric vector. Vector containing the thresholds for the piecewise Pareto distribution
\item \code{alpha} Numeric vector. Vector containing the Pareto alphas of the piecewise Pareto distribution
\item \code{Status} Character. Information on whether the fit was successful
\item \code{FQ} Numerical. Frequency in excess of the lowest threshold of the piecewise Pareto distribution
}
}
\description{
Matches the expected losses of a tower of reinsurance layers using a piecewise Pareto severity
}
\examples{
AP <- Example1_AP
EL <- Example1_EL
PiecewisePareto_Match_Layer_Losses(AP, EL)
EL_unlimited <- rev(cumsum(rev(Example1_EL)))
PiecewisePareto_Match_Layer_Losses(AP, EL_unlimited, Unlimited_Layers = TRUE)
PiecewisePareto_Match_Layer_Losses(AP, EL, FQ_at_lowest_AttPt = 0.5)
Example1_FQ <- c(0.3, 0.15, 0.08, 0.02, 0.005)
PiecewisePareto_Match_Layer_Losses(AP, EL, Frequencies = Example1_FQ)

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
