% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{skeleton_stable}
\alias{skeleton_stable}
\title{Estimate (Initial) Skeleton of a DAG using the PC_stable Algorithm}
\usage{
skeleton_stable(suffStat, indepTest, alpha, labels, p, method = c("stable",
  "original", "stable.fast"), m.max = Inf, fixedGaps = NULL,
  fixedEdges = NULL, NAdelete = TRUE, verbose = FALSE)
}
\arguments{
\item{suffStat}{Sufficient statistics: List containing all necessary elements for the conditional independence decisions in the function indepTest.}

\item{indepTest}{Predefined function for testing conditional independence. The function is internally called as indepTest(x,y,S,suffStat) and tests conditional independence of x and y given S. Here, x and y are variables, and S is a (possibly empty) vector of variables (all variables are denoted by their column numbers in the adjacency matrix). suffStat is a list containing all relevant elements for the conditional independence decisions. The return value of indepTest is the p-value of the test for conditional independence.}

\item{alpha}{significance level (number in (0,1) for the individual conditional independence tests.}

\item{labels}{(optional) character vector of variable (or "node") names. Typically preferred to specifying p.}

\item{p}{(optional) number of variables (or nodes). May be specified if labels are not, in which case labels is set to 1:p.}

\item{method}{Character string specifying method; the default, "stable" provides an order-independent skeleton, see 'Details' below.}

\item{m.max}{Maximal size of the conditioning sets that are considered in the conditional independence tests.}

\item{fixedGaps}{logical symmetric matrix of dimension p*p. If entry [i,j] is true, the edge i-j is removed before starting the algorithm. Therefore, this edge is guaranteed to be absent in the resulting graph.}

\item{fixedEdges}{a logical symmetric matrix of dimension p*p. If entry [i,j] is true, the edge i-j is never considered for removal. Therefore, this edge is guaranteed to be present in the resulting graph.}

\item{NAdelete}{logical needed for the case indepTest(*) returns NA. If it is true, the corresponding edge is deleted, otherwise not.}

\item{verbose}{if TRUE, detailed output is provided.}
}
\value{
An object of class "pcAlgo" (see pcAlgo in the pcalg package) containing an estimate of the skeleton of the underlying DAG, the conditioning sets (sepset) that led to edge removals and several other parameters.
}
\description{
This is the skeleton (stable) function in the pcalg package. It is copied here to localise the parallel functions.
}
\examples{
##########################################
## Using skeleton_stable
##########################################
library(pcalg)
library(parallel)
data("gmG")
p<-ncol(gmG$x)
suffStat<-list(C=cor(gmG$x),n=nrow(gmG$x))
skeleton_stable(suffStat, indepTest=gaussCItest, p=p, method="stable", alpha=0.01)
}

