% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{format_data}
\alias{format_data}
\title{Format epidemiological data}
\usage{
format_data(
  s_date,
  e_date,
  cases = NULL,
  n_cases = NULL,
  deaths = NULL,
  n_deaths = NULL,
  name,
  pop
)
}
\arguments{
\item{s_date}{start date of the time series. It should be in the YYYY-MM-DD format.}

\item{e_date}{end date of the time series. It should be in the YYYY-MM-DD format.}

\item{cases}{numeric vector containing the cumulative case counts per day from the start date
until the end date.}

\item{n_cases}{numeric vector containing the new case counts per day from the start date
until the end date.}

\item{deaths}{numeric vector containing the cumulative death counts per day from the start date
until the end date.}

\item{n_deaths}{numeric vector containing the new death counts per day from the start date
until the end date.}

\item{name}{string specifying the location name.}

\item{pop}{numeric object that contains the population size of the given location.}
}
\value{
An object of S3 class \code{pandemicData}. It is a list with 3 items:
\describe{
  \item{\code{data}:}{ data frame with the number of cumulative cases, new cases
  or/and cumulative deaths and new deaths for each date, from \code{s_date} up to the \code{e_date} in the specified region.}
  \item{\code{name}:}{ string with the location name.}
  \item{\code{population}:}{numeric object that contains the population size of the given location.}
}
}
\description{
The purpose of this function is to format any data input
to be used directly in the \code{\link{pandemic_model}} function as the
\code{Y} argument.
}
\details{
This function requires that at least one of the data inputs \code{cases,
n_cases, deaths, n_deaths} is provided. If only cumulative data was inserted,
\code{format_data} will automatically calculate the new case counts. On the contrary,
if only new case counts were provided, then the cumulative counts will be calculated.
Check \code{\link{covid19BH}} for a complete example on how to use this function.
}
\examples{
\dontrun{

#illustrative epidemiological data
cases <- c(0,1,4,7,10,19)
n_cases <- c(cases[1], diff(cases))

#format data to use in pandemic_model
data <- format_data(s_date = "2021-01-01", e_date = "2021-01-06",
                    cases = cases, n_cases = n_cases,
                    name = "Example", pop = 1234)

data
plot(data)
}

}
\seealso{
\code{\link{covid19BH}}
}
