% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourToFreq.R
\name{contourToFreq}
\alias{contourToFreq}
\title{Add Frequency and Time to Pamguard Whistle Binaries}
\usage{
contourToFreq(data, verbose = FALSE)
}
\arguments{
\item{data}{either a \code{PamBinary} class object or just the \code{$data} from
a PamBinary object}

\item{verbose}{logical flag to print calculated parameters}
}
\value{
\code{data} with items \code{freq} and \code{time} added. These use the 
  calculated FFT window length, hope size, and sample rate to compute the frequency
  and time values of the saved whistle contour
}
\description{
Adds items \code{freq} and \code{time} to a Pamguard binary file
  from the Whistle & Moan Detector
}
\examples{

# load example whistle file
wmFile <- system.file('extdata', 'WM.pgdf', package='PamBinaries')
wmData <- loadPamguardBinaryFile(wmFile)
# converts contour and FFT slice numbers to frequency and time values
wmData <- contourToFreq(wmData)
wmData$data[[1]]$contour
wmData$data[[1]]$freq
wmData$data[[1]]$time

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
